/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.ServiceUIFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.ColorSupported;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.QueuedJobCount;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.print.event.PrintServiceAttributeListener;
import sun.print.AttributeUpdater;
import sun.print.ServiceNotifier;
import sun.print.SunAlternateMedia;
import sun.print.SunPrinterJobService;
import sun.print.Win32MediaTray;
import sun.print.Win32PrintJob;

public class Win32PrintService
implements PrintService,
AttributeUpdater,
SunPrinterJobService {
    public static MediaSize[] predefMedia;
    private static final DocFlavor[] supportedFlavors;
    private static final Class[] serviceAttrCats;
    private static Class[] otherAttrCats;
    private static final MediaSizeName[] dmPaperToPrintService;
    private static final MediaTray[] dmPaperBinToPrintService;
    private static int DM_PAPERSIZE;
    private static int DM_PRINTQUALITY;
    private static int DM_YRESOLUTION;
    private static final int DMRES_MEDIUM = -3;
    private static final int DMRES_HIGH = -4;
    private static final int DMORIENT_LANDSCAPE = 2;
    private static final int DMDUP_VERTICAL = 2;
    private static final int DMDUP_HORIZONTAL = 3;
    private static final int DMCOLLATE_TRUE = 1;
    private static final int DMPAPER_A2 = 66;
    private static final int DMPAPER_A6 = 70;
    private static final int DMPAPER_B6_JIS = 88;
    private String printer;
    private PrinterName name;
    private transient PrintServiceAttributeSet lastSet;
    private transient ServiceNotifier notifier = null;
    private DocFlavor[] supportedDocFlavors;
    private MediaSizeName[] mediaSizeNames;
    private MediaPrintableArea[] mediaPrintables;
    private MediaTray[] mediaTrays;
    private PrinterResolution[] printRes;
    private int nCopies;
    private int lenOptAttrCats;
    private int defQuality;
    private int defPaper;
    private int defYRes;
    private int defMedia;
    private int defCopies;
    private int defOrient;
    private int defCollate;
    private int defSides;
    private boolean isResSup;
    private boolean isCollateSup;
    private boolean isColorSup;
    private boolean isSidesSup;
    private boolean isPrQualitySup;
    private boolean gotTrays;
    private boolean gotCopies;
    private boolean mediaInitialized;
    static /* synthetic */ Class class$sun$print$Win32MediaSize;
    static /* synthetic */ Class class$javax$print$attribute$standard$PrinterName;
    static /* synthetic */ Class class$javax$print$attribute$standard$PrinterIsAcceptingJobs;
    static /* synthetic */ Class class$javax$print$attribute$standard$QueuedJobCount;
    static /* synthetic */ Class class$javax$print$attribute$standard$ColorSupported;
    static /* synthetic */ Class class$javax$print$attribute$standard$JobName;
    static /* synthetic */ Class class$javax$print$attribute$standard$RequestingUserName;
    static /* synthetic */ Class class$javax$print$attribute$standard$Copies;
    static /* synthetic */ Class class$javax$print$attribute$standard$Destination;
    static /* synthetic */ Class class$javax$print$attribute$standard$OrientationRequested;
    static /* synthetic */ Class class$javax$print$attribute$standard$PageRanges;
    static /* synthetic */ Class class$javax$print$attribute$standard$Media;
    static /* synthetic */ Class class$javax$print$attribute$standard$MediaPrintableArea;
    static /* synthetic */ Class class$javax$print$attribute$standard$Fidelity;
    static /* synthetic */ Class class$sun$print$SunAlternateMedia;
    static /* synthetic */ Class class$javax$print$attribute$standard$Chromaticity;
    static /* synthetic */ Class class$javax$print$attribute$PrintServiceAttribute;
    static /* synthetic */ Class class$javax$print$attribute$standard$Sides;
    static /* synthetic */ Class class$javax$print$attribute$standard$SheetCollate;
    static /* synthetic */ Class class$javax$print$attribute$standard$PrintQuality;
    static /* synthetic */ Class class$javax$print$attribute$standard$PrinterResolution;
    static /* synthetic */ Class class$javax$print$attribute$Attribute;
    static /* synthetic */ Class class$javax$print$attribute$standard$CopiesSupported;
    static /* synthetic */ Class class$sun$awt$windows$WPrinterJob;

    Win32PrintService(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null printer name");
        }
        this.printer = string;
        this.mediaInitialized = false;
        this.gotTrays = false;
        this.gotCopies = false;
        this.lenOptAttrCats = 0;
        int n2 = this.getCapabilities(this.printer);
        this.isColorSup = (n2 & 1) != 0;
        this.isSidesSup = (n2 & 2) != 0;
        if (this.isSidesSup) {
            ++this.lenOptAttrCats;
        }
        this.isCollateSup = (n2 & 4) != 0;
        ++this.lenOptAttrCats;
        int[] nArray = this.getDefaultSettings(this.printer);
        this.defPaper = nArray[0];
        this.defMedia = nArray[1];
        this.defYRes = nArray[2];
        this.defQuality = nArray[3];
        this.defCopies = nArray[4];
        this.defOrient = nArray[5];
        this.defSides = nArray[6];
        this.defCollate = nArray[7];
        boolean bl2 = this.isPrQualitySup = (n2 & 8) != 0 && this.defQuality >= -4 && this.defQuality < 0;
        if (this.isPrQualitySup) {
            ++this.lenOptAttrCats;
        }
        int n3 = supportedFlavors.length;
        if ((n2 & 0x10) != 0) {
            this.supportedDocFlavors = new DocFlavor[n3 + 3];
            System.arraycopy(supportedFlavors, 0, this.supportedDocFlavors, 0, n3);
            this.supportedDocFlavors[n3] = DocFlavor.BYTE_ARRAY.POSTSCRIPT;
            this.supportedDocFlavors[n3 + 1] = DocFlavor.INPUT_STREAM.POSTSCRIPT;
            this.supportedDocFlavors[n3 + 2] = DocFlavor.URL.POSTSCRIPT;
        } else {
            this.supportedDocFlavors = new DocFlavor[n3];
            System.arraycopy(supportedFlavors, 0, this.supportedDocFlavors, 0, n3);
        }
        this.printRes = this.getPrintResolutions();
        if (this.printRes != null && (this.isResSup = this.printRes.length > 0)) {
            ++this.lenOptAttrCats;
        }
    }

    public String getName() {
        return this.printer;
    }

    private PrinterName getPrinterName() {
        if (this.name == null) {
            this.name = new PrinterName(this.printer, null);
        }
        return this.name;
    }

    private MediaSizeName findWin32Media(int n2) {
        if (n2 >= 1 && n2 <= dmPaperToPrintService.length) {
            switch (n2) {
                case 66: {
                    return MediaSizeName.ISO_A2;
                }
                case 70: {
                    return MediaSizeName.ISO_A6;
                }
                case 88: {
                    return MediaSizeName.JIS_B6;
                }
            }
            return dmPaperToPrintService[n2 - 1];
        }
        return null;
    }

    private boolean isSameMedia(MediaSize mediaSize, MediaSize mediaSize2) {
        float f2 = mediaSize.getX(1000) - mediaSize2.getX(1000);
        float f3 = mediaSize.getY(1000) - mediaSize2.getY(1000);
        return Math.abs(f2) <= 1.0f && Math.abs(f3) <= 1.0f;
    }

    private MediaSizeName findMatchingMediaSizeName(MediaSize mediaSize) {
        if (predefMedia != null && mediaSize != null) {
            int n2 = 0;
            while (n2 < predefMedia.length) {
                if (predefMedia[n2] != null && this.isSameMedia(mediaSize, predefMedia[n2])) {
                    return predefMedia[n2].getMediaSizeName();
                }
                ++n2;
            }
        }
        return null;
    }

    private boolean addToUniqueList(ArrayList arrayList, MediaSizeName mediaSizeName) {
        int n2 = 0;
        while (n2 < arrayList.size()) {
            MediaSizeName mediaSizeName2 = (MediaSizeName)arrayList.get(n2);
            if (mediaSizeName2 == mediaSizeName) {
                return false;
            }
            ++n2;
        }
        arrayList.add(mediaSizeName);
        return true;
    }

    private synchronized void initMedia() {
        if (this.mediaInitialized) {
            return;
        }
        this.mediaInitialized = true;
        int[] nArray = this.getAllMediaIDs(this.printer);
        if (nArray == null) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        MediaSize[] mediaSizeArray = this.getMediaSizes();
        int n2 = 0;
        while (n2 < nArray.length) {
            boolean bl2;
            Attribute attribute;
            MediaSizeName mediaSizeName = this.findWin32Media(nArray[n2]);
            if (mediaSizeName == null) {
                attribute = null;
                if (mediaSizeArray != null) {
                    attribute = mediaSizeArray[n2];
                }
                mediaSizeName = this.findMatchingMediaSizeName((MediaSize)attribute);
            }
            if (mediaSizeName != null && (bl2 = this.addToUniqueList(arrayList, mediaSizeName))) {
                float[] fArray = this.getMediaPrintableArea(this.printer, nArray[n2]);
                attribute = new MediaPrintableArea(fArray[0], fArray[1], fArray[2], fArray[3], 25400);
                arrayList2.add(attribute);
            }
            ++n2;
        }
        this.mediaSizeNames = new MediaSizeName[arrayList.size()];
        arrayList.toArray(this.mediaSizeNames);
        this.mediaPrintables = new MediaPrintableArea[arrayList2.size()];
        arrayList2.toArray(this.mediaPrintables);
    }

    private synchronized MediaTray[] getMediaTrays() {
        if (this.gotTrays) {
            return this.mediaTrays;
        }
        this.gotTrays = true;
        int[] nArray = this.getAllMediaTrays(this.printer);
        if (nArray == null) {
            return null;
        }
        int n2 = nArray.length;
        MediaTray[] mediaTrayArray = new MediaTray[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = nArray[n4];
            if (n5 <= dmPaperBinToPrintService.length && dmPaperBinToPrintService[n5 - 1] != null) {
                mediaTrayArray[n3++] = n5 < 1 ? MediaTray.MAIN : dmPaperBinToPrintService[n5 - 1];
            }
            ++n4;
        }
        if (n3 == 0) {
            return null;
        }
        MediaTray[] mediaTrayArray2 = new MediaTray[n3];
        System.arraycopy(mediaTrayArray, 0, mediaTrayArray2, 0, n3);
        return mediaTrayArray2;
    }

    private MediaSize[] getMediaSizes() {
        int[] nArray = this.getAllMediaSizes(this.printer);
        if (nArray == null) {
            return null;
        }
        int n2 = nArray.length / 2;
        MediaSize[] mediaSizeArray = new MediaSize[n2];
        int n3 = 0;
        while (n3 < n2) {
            try {
                mediaSizeArray[n3] = new MediaSize(nArray[n3 * 2] / 10, nArray[n3 * 2 + 1] / 10, 1000);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n3;
        }
        return mediaSizeArray;
    }

    private PrinterIsAcceptingJobs getPrinterIsAcceptingJobs() {
        if (this.getJobStatus(this.printer, 2) != 1) {
            return PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS;
        }
        return PrinterIsAcceptingJobs.ACCEPTING_JOBS;
    }

    private QueuedJobCount getQueuedJobCount() {
        int n2 = this.getJobStatus(this.printer, 1);
        if (n2 != -1) {
            return new QueuedJobCount(n2);
        }
        return new QueuedJobCount(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSupportedCopies(Copies copies) {
        Win32PrintService win32PrintService = this;
        synchronized (win32PrintService) {
            if (!this.gotCopies) {
                this.nCopies = this.getCopiesSupported(this.printer);
                this.gotCopies = true;
            }
        }
        int n2 = copies.getValue();
        return n2 > 0 && n2 <= this.nCopies;
    }

    private boolean isSupportedMedia(MediaSizeName mediaSizeName) {
        if (!this.mediaInitialized) {
            this.initMedia();
        }
        if (this.mediaSizeNames != null) {
            int n2 = 0;
            while (n2 < this.mediaSizeNames.length) {
                if (mediaSizeName.equals(this.mediaSizeNames[n2])) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean isSupportedMediaPrintableArea(MediaPrintableArea mediaPrintableArea) {
        if (!this.mediaInitialized) {
            this.initMedia();
        }
        if (this.mediaPrintables != null) {
            int n2 = 0;
            while (n2 < this.mediaPrintables.length) {
                if (mediaPrintableArea.equals(this.mediaPrintables[n2])) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean isSupportedMediaTray(MediaTray mediaTray) {
        if (!this.gotTrays) {
            this.mediaTrays = this.getMediaTrays();
        }
        if (this.mediaTrays != null) {
            int n2 = 0;
            while (n2 < this.mediaTrays.length) {
                if (mediaTray.equals(this.mediaTrays[n2])) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private PrinterResolution[] getPrintResolutions() {
        int[] nArray = this.getAllResolutions(this.printer);
        if (nArray == null) {
            return null;
        }
        int n2 = nArray.length / 2;
        ArrayList arrayList = new ArrayList();
        int n3 = 0;
        while (n3 < n2) {
            try {
                PrinterResolution printerResolution = new PrinterResolution(nArray[n3 * 2], nArray[n3 * 2 + 1], 100);
                arrayList.add(printerResolution);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n3;
        }
        PrinterResolution[] printerResolutionArray = (PrinterResolution[])arrayList.toArray(new PrinterResolution[arrayList.size()]);
        return printerResolutionArray;
    }

    private boolean isSupportedResolution(PrinterResolution printerResolution) {
        if (this.printRes != null) {
            int n2 = 0;
            while (n2 < this.printRes.length) {
                if (printerResolution.equals(this.printRes[n2])) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public DocPrintJob createPrintJob() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new Win32PrintJob(this);
    }

    private PrintServiceAttributeSet getDynamicAttributes() {
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        hashPrintServiceAttributeSet.add(this.getPrinterIsAcceptingJobs());
        hashPrintServiceAttributeSet.add(this.getQueuedJobCount());
        return hashPrintServiceAttributeSet;
    }

    public PrintServiceAttributeSet getUpdatedAttributes() {
        PrintServiceAttributeSet printServiceAttributeSet = this.getDynamicAttributes();
        if (this.lastSet == null) {
            this.lastSet = printServiceAttributeSet;
            return AttributeSetUtilities.unmodifiableView(printServiceAttributeSet);
        }
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        Attribute[] attributeArray = printServiceAttributeSet.toArray();
        int n2 = 0;
        while (n2 < attributeArray.length) {
            Attribute attribute = attributeArray[n2];
            if (!this.lastSet.containsValue(attribute)) {
                hashPrintServiceAttributeSet.add(attribute);
            }
            ++n2;
        }
        this.lastSet = printServiceAttributeSet;
        return AttributeSetUtilities.unmodifiableView(hashPrintServiceAttributeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeNotifier() {
        Win32PrintService win32PrintService = this;
        synchronized (win32PrintService) {
            if (this.notifier != null) {
                this.notifier.wake();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
        Win32PrintService win32PrintService = this;
        synchronized (win32PrintService) {
            if (printServiceAttributeListener == null) {
                return;
            }
            if (this.notifier == null) {
                this.notifier = new ServiceNotifier(this);
            }
            this.notifier.addListener(printServiceAttributeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
        Win32PrintService win32PrintService = this;
        synchronized (win32PrintService) {
            if (printServiceAttributeListener == null || this.notifier == null) {
                return;
            }
            this.notifier.removeListener(printServiceAttributeListener);
            if (this.notifier.isEmpty()) {
                this.notifier.stopNotifier();
                this.notifier = null;
            }
        }
    }

    public PrintServiceAttribute getAttribute(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("category");
        }
        if (!(class$javax$print$attribute$PrintServiceAttribute == null ? (class$javax$print$attribute$PrintServiceAttribute = Win32PrintService.class$("javax.print.attribute.PrintServiceAttribute")) : class$javax$print$attribute$PrintServiceAttribute).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Not a PrintServiceAttribute");
        }
        if (clazz == (class$javax$print$attribute$standard$ColorSupported == null ? (class$javax$print$attribute$standard$ColorSupported = Win32PrintService.class$("javax.print.attribute.standard.ColorSupported")) : class$javax$print$attribute$standard$ColorSupported)) {
            if (this.isColorSup) {
                return ColorSupported.SUPPORTED;
            }
            return ColorSupported.NOT_SUPPORTED;
        }
        if (clazz == (class$javax$print$attribute$standard$PrinterName == null ? (class$javax$print$attribute$standard$PrinterName = Win32PrintService.class$("javax.print.attribute.standard.PrinterName")) : class$javax$print$attribute$standard$PrinterName)) {
            return this.getPrinterName();
        }
        if (clazz == (class$javax$print$attribute$standard$QueuedJobCount == null ? (class$javax$print$attribute$standard$QueuedJobCount = Win32PrintService.class$("javax.print.attribute.standard.QueuedJobCount")) : class$javax$print$attribute$standard$QueuedJobCount)) {
            return this.getQueuedJobCount();
        }
        if (clazz == (class$javax$print$attribute$standard$PrinterIsAcceptingJobs == null ? (class$javax$print$attribute$standard$PrinterIsAcceptingJobs = Win32PrintService.class$("javax.print.attribute.standard.PrinterIsAcceptingJobs")) : class$javax$print$attribute$standard$PrinterIsAcceptingJobs)) {
            return this.getPrinterIsAcceptingJobs();
        }
        return null;
    }

    public PrintServiceAttributeSet getAttributes() {
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        hashPrintServiceAttributeSet.add(this.getPrinterName());
        hashPrintServiceAttributeSet.add(this.getPrinterIsAcceptingJobs());
        hashPrintServiceAttributeSet.add(this.getQueuedJobCount());
        if (this.isColorSup) {
            hashPrintServiceAttributeSet.add(ColorSupported.SUPPORTED);
        } else {
            hashPrintServiceAttributeSet.add(ColorSupported.NOT_SUPPORTED);
        }
        return AttributeSetUtilities.unmodifiableView(hashPrintServiceAttributeSet);
    }

    public DocFlavor[] getSupportedDocFlavors() {
        int n2 = this.supportedDocFlavors.length;
        DocFlavor[] docFlavorArray = new DocFlavor[n2];
        System.arraycopy(this.supportedDocFlavors, 0, docFlavorArray, 0, n2);
        return docFlavorArray;
    }

    public boolean isDocFlavorSupported(DocFlavor docFlavor) {
        int n2 = 0;
        while (n2 < this.supportedDocFlavors.length) {
            if (docFlavor.equals(this.supportedDocFlavors[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Class[] getSupportedAttributeCategories() {
        int n2 = otherAttrCats.length;
        Class[] classArray = new Class[n2 + this.lenOptAttrCats];
        System.arraycopy(otherAttrCats, 0, classArray, 0, otherAttrCats.length);
        int n3 = n2;
        if (this.isSidesSup) {
            classArray[n3++] = class$javax$print$attribute$standard$Sides == null ? (class$javax$print$attribute$standard$Sides = Win32PrintService.class$("javax.print.attribute.standard.Sides")) : class$javax$print$attribute$standard$Sides;
        }
        Class clazz = classArray[n3++] = class$javax$print$attribute$standard$SheetCollate == null ? (class$javax$print$attribute$standard$SheetCollate = Win32PrintService.class$("javax.print.attribute.standard.SheetCollate")) : class$javax$print$attribute$standard$SheetCollate;
        if (this.isPrQualitySup) {
            Class clazz2 = classArray[n3++] = class$javax$print$attribute$standard$PrintQuality == null ? (class$javax$print$attribute$standard$PrintQuality = Win32PrintService.class$("javax.print.attribute.standard.PrintQuality")) : class$javax$print$attribute$standard$PrintQuality;
        }
        if (this.isResSup) {
            classArray[n3++] = class$javax$print$attribute$standard$PrinterResolution == null ? (class$javax$print$attribute$standard$PrinterResolution = Win32PrintService.class$("javax.print.attribute.standard.PrinterResolution")) : class$javax$print$attribute$standard$PrinterResolution;
        }
        return classArray;
    }

    public boolean isAttributeCategorySupported(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!(class$javax$print$attribute$Attribute == null ? (class$javax$print$attribute$Attribute = Win32PrintService.class$("javax.print.attribute.Attribute")) : class$javax$print$attribute$Attribute).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is not an Attribute");
        }
        int n2 = 0;
        while (n2 < otherAttrCats.length) {
            if (clazz == otherAttrCats[n2]) {
                return true;
            }
            ++n2;
        }
        if (clazz == (class$javax$print$attribute$standard$Sides == null ? (class$javax$print$attribute$standard$Sides = Win32PrintService.class$("javax.print.attribute.standard.Sides")) : class$javax$print$attribute$standard$Sides) && this.isSidesSup) {
            return true;
        }
        if (clazz == (class$javax$print$attribute$standard$SheetCollate == null ? (class$javax$print$attribute$standard$SheetCollate = Win32PrintService.class$("javax.print.attribute.standard.SheetCollate")) : class$javax$print$attribute$standard$SheetCollate)) {
            return true;
        }
        if (clazz == (class$javax$print$attribute$standard$PrintQuality == null ? (class$javax$print$attribute$standard$PrintQuality = Win32PrintService.class$("javax.print.attribute.standard.PrintQuality")) : class$javax$print$attribute$standard$PrintQuality) && this.isPrQualitySup) {
            return true;
        }
        return clazz == (class$javax$print$attribute$standard$PrinterResolution == null ? (class$javax$print$attribute$standard$PrinterResolution = Win32PrintService.class$("javax.print.attribute.standard.PrinterResolution")) : class$javax$print$attribute$standard$PrinterResolution) && this.isResSup;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getDefaultAttributeValue(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!(class$javax$print$attribute$Attribute == null ? (class$javax$print$attribute$Attribute = Win32PrintService.class$("javax.print.attribute.Attribute")) : class$javax$print$attribute$Attribute).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is not an Attribute");
        }
        if (!this.isAttributeCategorySupported(clazz)) {
            return null;
        }
        if (clazz == (class$javax$print$attribute$standard$Copies == null ? (class$javax$print$attribute$standard$Copies = Win32PrintService.class$("javax.print.attribute.standard.Copies")) : class$javax$print$attribute$standard$Copies)) {
            if (this.defCopies <= 0) return new Copies(1);
            return new Copies(this.defCopies);
        }
        if (clazz == (class$javax$print$attribute$standard$Chromaticity == null ? (class$javax$print$attribute$standard$Chromaticity = Win32PrintService.class$("javax.print.attribute.standard.Chromaticity")) : class$javax$print$attribute$standard$Chromaticity)) {
            if (this.isColorSup) return Chromaticity.COLOR;
            return Chromaticity.MONOCHROME;
        }
        if (clazz == (class$javax$print$attribute$standard$JobName == null ? (class$javax$print$attribute$standard$JobName = Win32PrintService.class$("javax.print.attribute.standard.JobName")) : class$javax$print$attribute$standard$JobName)) {
            return new JobName("Java Printing", null);
        }
        if (clazz == (class$javax$print$attribute$standard$OrientationRequested == null ? (class$javax$print$attribute$standard$OrientationRequested = Win32PrintService.class$("javax.print.attribute.standard.OrientationRequested")) : class$javax$print$attribute$standard$OrientationRequested)) {
            if (this.defOrient != 2) return OrientationRequested.PORTRAIT;
            return OrientationRequested.LANDSCAPE;
        }
        if (clazz == (class$javax$print$attribute$standard$PageRanges == null ? (class$javax$print$attribute$standard$PageRanges = Win32PrintService.class$("javax.print.attribute.standard.PageRanges")) : class$javax$print$attribute$standard$PageRanges)) {
            return new PageRanges(1, Integer.MAX_VALUE);
        }
        if (clazz == (class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = Win32PrintService.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media)) {
            MediaSizeName mediaSizeName = this.findWin32Media(this.defPaper);
            if (mediaSizeName != null) {
                return mediaSizeName;
            }
            if (!this.mediaInitialized) {
                this.initMedia();
            }
            if (this.mediaSizeNames == null) return null;
            return this.mediaSizeNames[0];
        }
        if (clazz == (class$javax$print$attribute$standard$MediaPrintableArea == null ? (class$javax$print$attribute$standard$MediaPrintableArea = Win32PrintService.class$("javax.print.attribute.standard.MediaPrintableArea")) : class$javax$print$attribute$standard$MediaPrintableArea)) {
            float[] fArray = this.getMediaPrintableArea(this.printer, this.defPaper);
            return new MediaPrintableArea(fArray[0], fArray[1], fArray[2], fArray[3], 25400);
        }
        if (clazz == (class$sun$print$SunAlternateMedia == null ? (class$sun$print$SunAlternateMedia = Win32PrintService.class$("sun.print.SunAlternateMedia")) : class$sun$print$SunAlternateMedia)) {
            return null;
        }
        if (clazz == (class$javax$print$attribute$standard$Destination == null ? (class$javax$print$attribute$standard$Destination = Win32PrintService.class$("javax.print.attribute.standard.Destination")) : class$javax$print$attribute$standard$Destination)) {
            return new Destination(new File("out.prn").toURI());
        }
        if (clazz == (class$javax$print$attribute$standard$Sides == null ? (class$javax$print$attribute$standard$Sides = Win32PrintService.class$("javax.print.attribute.standard.Sides")) : class$javax$print$attribute$standard$Sides)) {
            switch (this.defSides) {
                case 2: {
                    return Sides.TWO_SIDED_LONG_EDGE;
                }
                case 3: {
                    return Sides.TWO_SIDED_SHORT_EDGE;
                }
            }
            return Sides.ONE_SIDED;
        }
        if (clazz == (class$javax$print$attribute$standard$PrinterResolution == null ? (class$javax$print$attribute$standard$PrinterResolution = Win32PrintService.class$("javax.print.attribute.standard.PrinterResolution")) : class$javax$print$attribute$standard$PrinterResolution)) {
            int n2 = this.defYRes;
            int n3 = this.defQuality;
            if (n3 >= 0) {
                if (n2 >= 0) return new PrinterResolution(n3, n2, 100);
            }
            int n4 = n2 > n3 ? n2 : n3;
            if (n4 <= 0) return null;
            return new PrinterResolution(n4, n4, 100);
        }
        if (clazz == (class$javax$print$attribute$standard$ColorSupported == null ? (class$javax$print$attribute$standard$ColorSupported = Win32PrintService.class$("javax.print.attribute.standard.ColorSupported")) : class$javax$print$attribute$standard$ColorSupported)) {
            if (!this.isColorSup) return ColorSupported.NOT_SUPPORTED;
            return ColorSupported.SUPPORTED;
        }
        if (clazz == (class$javax$print$attribute$standard$PrintQuality == null ? (class$javax$print$attribute$standard$PrintQuality = Win32PrintService.class$("javax.print.attribute.standard.PrintQuality")) : class$javax$print$attribute$standard$PrintQuality)) {
            if (this.defQuality >= 0) return null;
            if (this.defQuality < -4) return null;
            switch (this.defQuality) {
                case -4: {
                    return PrintQuality.HIGH;
                }
                case -3: {
                    return PrintQuality.NORMAL;
                }
            }
            return PrintQuality.DRAFT;
        }
        if (clazz == (class$javax$print$attribute$standard$RequestingUserName == null ? (class$javax$print$attribute$standard$RequestingUserName = Win32PrintService.class$("javax.print.attribute.standard.RequestingUserName")) : class$javax$print$attribute$standard$RequestingUserName)) {
            String string = "";
            try {
                string = System.getProperty("user.name", "");
                return new RequestingUserName(string, null);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return new RequestingUserName(string, null);
        }
        if (clazz == (class$javax$print$attribute$standard$SheetCollate == null ? (class$javax$print$attribute$standard$SheetCollate = Win32PrintService.class$("javax.print.attribute.standard.SheetCollate")) : class$javax$print$attribute$standard$SheetCollate)) {
            if (this.defCollate != 1) return SheetCollate.UNCOLLATED;
            return SheetCollate.COLLATED;
        }
        if (clazz != (class$javax$print$attribute$standard$Fidelity == null ? (class$javax$print$attribute$standard$Fidelity = Win32PrintService.class$("javax.print.attribute.standard.Fidelity")) : class$javax$print$attribute$standard$Fidelity)) return null;
        return Fidelity.FIDELITY_FALSE;
    }

    private boolean isPostScriptFlavor(DocFlavor docFlavor) {
        return docFlavor.equals(DocFlavor.BYTE_ARRAY.POSTSCRIPT) || docFlavor.equals(DocFlavor.INPUT_STREAM.POSTSCRIPT) || docFlavor.equals(DocFlavor.URL.POSTSCRIPT);
    }

    private boolean isPSDocAttr(Class clazz) {
        return clazz == (class$javax$print$attribute$standard$OrientationRequested == null ? (class$javax$print$attribute$standard$OrientationRequested = Win32PrintService.class$("javax.print.attribute.standard.OrientationRequested")) : class$javax$print$attribute$standard$OrientationRequested);
    }

    private boolean isAutoSense(DocFlavor docFlavor) {
        return docFlavor.equals(DocFlavor.BYTE_ARRAY.AUTOSENSE) || docFlavor.equals(DocFlavor.INPUT_STREAM.AUTOSENSE) || docFlavor.equals(DocFlavor.URL.AUTOSENSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSupportedAttributeValues(Class clazz, DocFlavor docFlavor, AttributeSet attributeSet) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!(class$javax$print$attribute$Attribute == null ? (class$javax$print$attribute$Attribute = Win32PrintService.class$("javax.print.attribute.Attribute")) : class$javax$print$attribute$Attribute).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " does not implement Attribute");
        }
        if (docFlavor != null) {
            if (!this.isDocFlavorSupported(docFlavor)) {
                throw new IllegalArgumentException(docFlavor + " is an unsupported flavor");
            }
            if (this.isAutoSense(docFlavor) || this.isPostScriptFlavor(docFlavor) && this.isPSDocAttr(clazz)) {
                return null;
            }
        }
        if (!this.isAttributeCategorySupported(clazz)) {
            return null;
        }
        if (clazz == (class$javax$print$attribute$standard$JobName == null ? (class$javax$print$attribute$standard$JobName = Win32PrintService.class$("javax.print.attribute.standard.JobName")) : class$javax$print$attribute$standard$JobName)) {
            return new JobName("Java Printing", null);
        }
        if (clazz == (class$javax$print$attribute$standard$RequestingUserName == null ? (class$javax$print$attribute$standard$RequestingUserName = Win32PrintService.class$("javax.print.attribute.standard.RequestingUserName")) : class$javax$print$attribute$standard$RequestingUserName)) {
            String string = "";
            try {
                string = System.getProperty("user.name", "");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return new RequestingUserName(string, null);
        }
        if (clazz == (class$javax$print$attribute$standard$ColorSupported == null ? (class$javax$print$attribute$standard$ColorSupported = Win32PrintService.class$("javax.print.attribute.standard.ColorSupported")) : class$javax$print$attribute$standard$ColorSupported)) {
            if (this.isColorSup) {
                return ColorSupported.SUPPORTED;
            }
            return ColorSupported.NOT_SUPPORTED;
        }
        if (clazz == (class$javax$print$attribute$standard$Chromaticity == null ? (class$javax$print$attribute$standard$Chromaticity = Win32PrintService.class$("javax.print.attribute.standard.Chromaticity")) : class$javax$print$attribute$standard$Chromaticity)) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) || docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) || docFlavor.equals(DocFlavor.URL.GIF) || docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) || docFlavor.equals(DocFlavor.URL.JPEG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG) || docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) || docFlavor.equals(DocFlavor.URL.PNG)) {
                if (!this.isColorSup) {
                    Chromaticity[] chromaticityArray = new Chromaticity[]{Chromaticity.MONOCHROME};
                    return chromaticityArray;
                }
                Chromaticity[] chromaticityArray = new Chromaticity[]{Chromaticity.MONOCHROME, Chromaticity.COLOR};
                return chromaticityArray;
            }
            return null;
        }
        if (clazz == (class$javax$print$attribute$standard$Destination == null ? (class$javax$print$attribute$standard$Destination = Win32PrintService.class$("javax.print.attribute.standard.Destination")) : class$javax$print$attribute$standard$Destination)) {
            return new Destination(new File("out.prn").toURI());
        }
        if (clazz == (class$javax$print$attribute$standard$OrientationRequested == null ? (class$javax$print$attribute$standard$OrientationRequested = Win32PrintService.class$("javax.print.attribute.standard.OrientationRequested")) : class$javax$print$attribute$standard$OrientationRequested)) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) || docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) || docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) || docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG) || docFlavor.equals(DocFlavor.URL.GIF) || docFlavor.equals(DocFlavor.URL.JPEG) || docFlavor.equals(DocFlavor.URL.PNG)) {
                OrientationRequested[] orientationRequestedArray = new OrientationRequested[]{OrientationRequested.PORTRAIT, OrientationRequested.LANDSCAPE, OrientationRequested.REVERSE_LANDSCAPE};
                return orientationRequestedArray;
            }
            return null;
        }
        if (clazz == (class$javax$print$attribute$standard$Copies == null ? (class$javax$print$attribute$standard$Copies = Win32PrintService.class$("javax.print.attribute.standard.Copies")) : class$javax$print$attribute$standard$Copies) || clazz == (class$javax$print$attribute$standard$CopiesSupported == null ? (class$javax$print$attribute$standard$CopiesSupported = Win32PrintService.class$("javax.print.attribute.standard.CopiesSupported")) : class$javax$print$attribute$standard$CopiesSupported)) {
            Win32PrintService win32PrintService = this;
            synchronized (win32PrintService) {
                if (!this.gotCopies) {
                    this.nCopies = this.getCopiesSupported(this.printer);
                    this.gotCopies = true;
                }
            }
            return new CopiesSupported(1, this.nCopies);
        }
        if (clazz == (class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = Win32PrintService.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media)) {
            int n2;
            if (!this.mediaInitialized) {
                this.initMedia();
            }
            int n3 = n2 = this.mediaSizeNames == null ? 0 : this.mediaSizeNames.length;
            if (!this.gotTrays) {
                this.mediaTrays = this.getMediaTrays();
            }
            Media[] mediaArray = new Media[n2 += this.mediaTrays == null ? 0 : this.mediaTrays.length];
            if (this.mediaSizeNames != null) {
                System.arraycopy(this.mediaSizeNames, 0, mediaArray, 0, this.mediaSizeNames.length);
            }
            if (this.mediaTrays != null) {
                System.arraycopy(this.mediaTrays, 0, mediaArray, this.mediaSizeNames.length, this.mediaTrays.length);
            }
            return mediaArray;
        }
        if (clazz == (class$javax$print$attribute$standard$MediaPrintableArea == null ? (class$javax$print$attribute$standard$MediaPrintableArea = Win32PrintService.class$("javax.print.attribute.standard.MediaPrintableArea")) : class$javax$print$attribute$standard$MediaPrintableArea)) {
            Media media;
            if (attributeSet != null && (media = (Media)attributeSet.get(class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = Win32PrintService.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media)) != null && media instanceof MediaSizeName) {
                int n4 = 0;
                int n5 = 0;
                while (n5 < dmPaperToPrintService.length) {
                    if (dmPaperToPrintService[n5] == media) {
                        n4 = n5 + 1;
                        break;
                    }
                    ++n5;
                }
                float[] fArray = this.getMediaPrintableArea(this.printer, n4);
                MediaPrintableArea[] mediaPrintableAreaArray = new MediaPrintableArea[]{new MediaPrintableArea(fArray[0], fArray[1], fArray[2], fArray[3], 25400)};
                return mediaPrintableAreaArray;
            }
            if (!this.mediaInitialized) {
                this.initMedia();
            }
            if (this.mediaPrintables == null) {
                return null;
            }
            MediaPrintableArea[] mediaPrintableAreaArray = new MediaPrintableArea[this.mediaPrintables.length];
            System.arraycopy(this.mediaPrintables, 0, mediaPrintableAreaArray, 0, this.mediaPrintables.length);
            return mediaPrintableAreaArray;
        }
        if (clazz == (class$sun$print$SunAlternateMedia == null ? (class$sun$print$SunAlternateMedia = Win32PrintService.class$("sun.print.SunAlternateMedia")) : class$sun$print$SunAlternateMedia)) {
            return new SunAlternateMedia((Media)this.getDefaultAttributeValue(class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = Win32PrintService.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media));
        }
        if (clazz == (class$javax$print$attribute$standard$PageRanges == null ? (class$javax$print$attribute$standard$PageRanges = Win32PrintService.class$("javax.print.attribute.standard.PageRanges")) : class$javax$print$attribute$standard$PageRanges)) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                PageRanges[] pageRangesArray = new PageRanges[]{new PageRanges(1, Integer.MAX_VALUE)};
                return pageRangesArray;
            }
            return null;
        }
        if (clazz == (class$javax$print$attribute$standard$PrinterResolution == null ? (class$javax$print$attribute$standard$PrinterResolution = Win32PrintService.class$("javax.print.attribute.standard.PrinterResolution")) : class$javax$print$attribute$standard$PrinterResolution)) {
            if (this.printRes == null) {
                return null;
            }
            PrinterResolution[] printerResolutionArray = new PrinterResolution[this.printRes.length];
            System.arraycopy(this.printRes, 0, printerResolutionArray, 0, this.printRes.length);
            return printerResolutionArray;
        }
        if (clazz == (class$javax$print$attribute$standard$Sides == null ? (class$javax$print$attribute$standard$Sides = Win32PrintService.class$("javax.print.attribute.standard.Sides")) : class$javax$print$attribute$standard$Sides)) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                Sides[] sidesArray = new Sides[]{Sides.ONE_SIDED, Sides.TWO_SIDED_LONG_EDGE, Sides.TWO_SIDED_SHORT_EDGE};
                return sidesArray;
            }
            return null;
        }
        if (clazz == (class$javax$print$attribute$standard$PrintQuality == null ? (class$javax$print$attribute$standard$PrintQuality = Win32PrintService.class$("javax.print.attribute.standard.PrintQuality")) : class$javax$print$attribute$standard$PrintQuality)) {
            PrintQuality[] printQualityArray = new PrintQuality[]{PrintQuality.DRAFT, PrintQuality.HIGH, PrintQuality.NORMAL};
            return printQualityArray;
        }
        if (clazz == (class$javax$print$attribute$standard$SheetCollate == null ? (class$javax$print$attribute$standard$SheetCollate = Win32PrintService.class$("javax.print.attribute.standard.SheetCollate")) : class$javax$print$attribute$standard$SheetCollate)) {
            if (this.isCollateSup && (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE))) {
                SheetCollate[] sheetCollateArray = new SheetCollate[]{SheetCollate.COLLATED, SheetCollate.UNCOLLATED};
                return sheetCollateArray;
            }
            SheetCollate[] sheetCollateArray = new SheetCollate[]{SheetCollate.UNCOLLATED};
            return sheetCollateArray;
        }
        if (clazz == (class$javax$print$attribute$standard$Fidelity == null ? (class$javax$print$attribute$standard$Fidelity = Win32PrintService.class$("javax.print.attribute.standard.Fidelity")) : class$javax$print$attribute$standard$Fidelity)) {
            Fidelity[] fidelityArray = new Fidelity[]{Fidelity.FIDELITY_FALSE, Fidelity.FIDELITY_TRUE};
            return fidelityArray;
        }
        return null;
    }

    public boolean isAttributeValueSupported(Attribute attribute, DocFlavor docFlavor, AttributeSet attributeSet) {
        if (attribute == null) {
            throw new NullPointerException("null attribute");
        }
        Class clazz = attribute.getCategory();
        if (docFlavor != null) {
            if (!this.isDocFlavorSupported(docFlavor)) {
                throw new IllegalArgumentException(docFlavor + " is an unsupported flavor");
            }
            if (this.isAutoSense(docFlavor) || this.isPostScriptFlavor(docFlavor) && this.isPSDocAttr(clazz)) {
                return false;
            }
        }
        if (!this.isAttributeCategorySupported(clazz)) {
            return false;
        }
        if (attribute.getCategory() == (class$javax$print$attribute$standard$Chromaticity == null ? (class$javax$print$attribute$standard$Chromaticity = Win32PrintService.class$("javax.print.attribute.standard.Chromaticity")) : class$javax$print$attribute$standard$Chromaticity)) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) || docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) || docFlavor.equals(DocFlavor.URL.GIF) || docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) || docFlavor.equals(DocFlavor.URL.JPEG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG) || docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) || docFlavor.equals(DocFlavor.URL.PNG)) {
                if (this.isColorSup) {
                    return true;
                }
                return attribute == Chromaticity.MONOCHROME;
            }
            return false;
        }
        if (attribute.getCategory() == (class$javax$print$attribute$standard$Copies == null ? (class$javax$print$attribute$standard$Copies = Win32PrintService.class$("javax.print.attribute.standard.Copies")) : class$javax$print$attribute$standard$Copies)) {
            return this.isSupportedCopies((Copies)attribute);
        }
        if (attribute.getCategory() == (class$javax$print$attribute$standard$Destination == null ? (class$javax$print$attribute$standard$Destination = Win32PrintService.class$("javax.print.attribute.standard.Destination")) : class$javax$print$attribute$standard$Destination)) {
            URI uRI = ((Destination)attribute).getURI();
            return "file".equals(uRI.getScheme()) && !uRI.getSchemeSpecificPart().equals("");
        }
        if (attribute.getCategory() == (class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = Win32PrintService.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media)) {
            if (attribute instanceof MediaSizeName) {
                return this.isSupportedMedia((MediaSizeName)attribute);
            }
            if (attribute instanceof MediaTray) {
                return this.isSupportedMediaTray((MediaTray)attribute);
            }
        } else {
            if (attribute.getCategory() == (class$javax$print$attribute$standard$MediaPrintableArea == null ? (class$javax$print$attribute$standard$MediaPrintableArea = Win32PrintService.class$("javax.print.attribute.standard.MediaPrintableArea")) : class$javax$print$attribute$standard$MediaPrintableArea)) {
                return this.isSupportedMediaPrintableArea((MediaPrintableArea)attribute);
            }
            if (attribute.getCategory() == (class$sun$print$SunAlternateMedia == null ? (class$sun$print$SunAlternateMedia = Win32PrintService.class$("sun.print.SunAlternateMedia")) : class$sun$print$SunAlternateMedia)) {
                Media media = ((SunAlternateMedia)attribute).getMedia();
                return this.isAttributeValueSupported(media, docFlavor, attributeSet);
            }
            if (attribute.getCategory() == (class$javax$print$attribute$standard$PageRanges == null ? (class$javax$print$attribute$standard$PageRanges = Win32PrintService.class$("javax.print.attribute.standard.PageRanges")) : class$javax$print$attribute$standard$PageRanges)) {
                if (docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                    return false;
                }
            } else if (attribute.getCategory() == (class$javax$print$attribute$standard$SheetCollate == null ? (class$javax$print$attribute$standard$SheetCollate = Win32PrintService.class$("javax.print.attribute.standard.SheetCollate")) : class$javax$print$attribute$standard$SheetCollate)) {
                if (docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                    return false;
                }
            } else if (attribute.getCategory() == (class$javax$print$attribute$standard$Sides == null ? (class$javax$print$attribute$standard$Sides = Win32PrintService.class$("javax.print.attribute.standard.Sides")) : class$javax$print$attribute$standard$Sides)) {
                if (docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                    return false;
                }
            } else if (attribute.getCategory() == (class$javax$print$attribute$standard$PrinterResolution == null ? (class$javax$print$attribute$standard$PrinterResolution = Win32PrintService.class$("javax.print.attribute.standard.PrinterResolution")) : class$javax$print$attribute$standard$PrinterResolution)) {
                if (attribute instanceof PrinterResolution) {
                    return this.isSupportedResolution((PrinterResolution)attribute);
                }
            } else if (attribute.getCategory() == (class$javax$print$attribute$standard$OrientationRequested == null ? (class$javax$print$attribute$standard$OrientationRequested = Win32PrintService.class$("javax.print.attribute.standard.OrientationRequested")) : class$javax$print$attribute$standard$OrientationRequested) ? attribute == OrientationRequested.REVERSE_PORTRAIT || docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) && !docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) && !docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) && !docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) && !docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) && !docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) && !docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG) && !docFlavor.equals(DocFlavor.URL.GIF) && !docFlavor.equals(DocFlavor.URL.JPEG) && !docFlavor.equals(DocFlavor.URL.PNG) : attribute.getCategory() == (class$javax$print$attribute$standard$ColorSupported == null ? (class$javax$print$attribute$standard$ColorSupported = Win32PrintService.class$("javax.print.attribute.standard.ColorSupported")) : class$javax$print$attribute$standard$ColorSupported) && (!this.isColorSup && attribute == ColorSupported.SUPPORTED || this.isColorSup && attribute == ColorSupported.NOT_SUPPORTED)) {
                return false;
            }
        }
        return true;
    }

    public AttributeSet getUnsupportedAttributes(DocFlavor docFlavor, AttributeSet attributeSet) {
        if (docFlavor != null && !this.isDocFlavorSupported(docFlavor)) {
            throw new IllegalArgumentException("flavor " + docFlavor + "is not supported");
        }
        if (attributeSet == null) {
            return null;
        }
        HashAttributeSet hashAttributeSet = new HashAttributeSet();
        Attribute[] attributeArray = attributeSet.toArray();
        int n2 = 0;
        while (n2 < attributeArray.length) {
            try {
                Attribute attribute = attributeArray[n2];
                if (!this.isAttributeCategorySupported(attribute.getCategory())) {
                    hashAttributeSet.add(attribute);
                } else if (!this.isAttributeValueSupported(attribute, docFlavor, attributeSet)) {
                    hashAttributeSet.add(attribute);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++n2;
        }
        if (hashAttributeSet.isEmpty()) {
            return null;
        }
        return hashAttributeSet;
    }

    public ServiceUIFactory getServiceUIFactory() {
        return null;
    }

    public String toString() {
        return "Win32 Printer : " + this.getName();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Win32PrintService && ((Win32PrintService)object).getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getClass().hashCode() + this.getName().hashCode();
    }

    public boolean usesClass(Class clazz) {
        return clazz == (class$sun$awt$windows$WPrinterJob == null ? (class$sun$awt$windows$WPrinterJob = Win32PrintService.class$("sun.awt.windows.WPrinterJob")) : class$sun$awt$windows$WPrinterJob);
    }

    private native int[] getAllMediaIDs(String var1);

    private native int[] getAllMediaSizes(String var1);

    private native int[] getAllMediaTrays(String var1);

    private native float[] getMediaPrintableArea(String var1, int var2);

    private native int getCopiesSupported(String var1);

    private native int[] getAllResolutions(String var1);

    private native int getCapabilities(String var1);

    private native int[] getDefaultSettings(String var1);

    private native int getJobStatus(String var1, int var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$sun$print$Win32MediaSize == null ? (class$sun$print$Win32MediaSize = Win32PrintService.class$("sun.print.Win32MediaSize")) : class$sun$print$Win32MediaSize;
        supportedFlavors = new DocFlavor[]{DocFlavor.BYTE_ARRAY.GIF, DocFlavor.INPUT_STREAM.GIF, DocFlavor.URL.GIF, DocFlavor.BYTE_ARRAY.JPEG, DocFlavor.INPUT_STREAM.JPEG, DocFlavor.URL.JPEG, DocFlavor.BYTE_ARRAY.PNG, DocFlavor.INPUT_STREAM.PNG, DocFlavor.URL.PNG, DocFlavor.SERVICE_FORMATTED.PAGEABLE, DocFlavor.SERVICE_FORMATTED.PRINTABLE, DocFlavor.BYTE_ARRAY.AUTOSENSE, DocFlavor.URL.AUTOSENSE, DocFlavor.INPUT_STREAM.AUTOSENSE};
        serviceAttrCats = new Class[]{class$javax$print$attribute$standard$PrinterName == null ? (class$javax$print$attribute$standard$PrinterName = Win32PrintService.class$("javax.print.attribute.standard.PrinterName")) : class$javax$print$attribute$standard$PrinterName, class$javax$print$attribute$standard$PrinterIsAcceptingJobs == null ? (class$javax$print$attribute$standard$PrinterIsAcceptingJobs = Win32PrintService.class$("javax.print.attribute.standard.PrinterIsAcceptingJobs")) : class$javax$print$attribute$standard$PrinterIsAcceptingJobs, class$javax$print$attribute$standard$QueuedJobCount == null ? (class$javax$print$attribute$standard$QueuedJobCount = Win32PrintService.class$("javax.print.attribute.standard.QueuedJobCount")) : class$javax$print$attribute$standard$QueuedJobCount, class$javax$print$attribute$standard$ColorSupported == null ? (class$javax$print$attribute$standard$ColorSupported = Win32PrintService.class$("javax.print.attribute.standard.ColorSupported")) : class$javax$print$attribute$standard$ColorSupported};
        otherAttrCats = new Class[]{class$javax$print$attribute$standard$JobName == null ? (class$javax$print$attribute$standard$JobName = Win32PrintService.class$("javax.print.attribute.standard.JobName")) : class$javax$print$attribute$standard$JobName, class$javax$print$attribute$standard$RequestingUserName == null ? (class$javax$print$attribute$standard$RequestingUserName = Win32PrintService.class$("javax.print.attribute.standard.RequestingUserName")) : class$javax$print$attribute$standard$RequestingUserName, class$javax$print$attribute$standard$Copies == null ? (class$javax$print$attribute$standard$Copies = Win32PrintService.class$("javax.print.attribute.standard.Copies")) : class$javax$print$attribute$standard$Copies, class$javax$print$attribute$standard$Destination == null ? (class$javax$print$attribute$standard$Destination = Win32PrintService.class$("javax.print.attribute.standard.Destination")) : class$javax$print$attribute$standard$Destination, class$javax$print$attribute$standard$OrientationRequested == null ? (class$javax$print$attribute$standard$OrientationRequested = Win32PrintService.class$("javax.print.attribute.standard.OrientationRequested")) : class$javax$print$attribute$standard$OrientationRequested, class$javax$print$attribute$standard$PageRanges == null ? (class$javax$print$attribute$standard$PageRanges = Win32PrintService.class$("javax.print.attribute.standard.PageRanges")) : class$javax$print$attribute$standard$PageRanges, class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = Win32PrintService.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media, class$javax$print$attribute$standard$MediaPrintableArea == null ? (class$javax$print$attribute$standard$MediaPrintableArea = Win32PrintService.class$("javax.print.attribute.standard.MediaPrintableArea")) : class$javax$print$attribute$standard$MediaPrintableArea, class$javax$print$attribute$standard$Fidelity == null ? (class$javax$print$attribute$standard$Fidelity = Win32PrintService.class$("javax.print.attribute.standard.Fidelity")) : class$javax$print$attribute$standard$Fidelity, class$sun$print$SunAlternateMedia == null ? (class$sun$print$SunAlternateMedia = Win32PrintService.class$("sun.print.SunAlternateMedia")) : class$sun$print$SunAlternateMedia, class$javax$print$attribute$standard$Chromaticity == null ? (class$javax$print$attribute$standard$Chromaticity = Win32PrintService.class$("javax.print.attribute.standard.Chromaticity")) : class$javax$print$attribute$standard$Chromaticity};
        dmPaperToPrintService = new MediaSizeName[]{MediaSizeName.NA_LETTER, MediaSizeName.NA_LETTER, MediaSizeName.TABLOID, MediaSizeName.LEDGER, MediaSizeName.NA_LEGAL, MediaSizeName.INVOICE, MediaSizeName.EXECUTIVE, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, MediaSizeName.ISO_A4, MediaSizeName.ISO_A5, MediaSizeName.JIS_B4, MediaSizeName.JIS_B5, MediaSizeName.FOLIO, MediaSizeName.QUARTO, MediaSizeName.NA_10X14_ENVELOPE, MediaSizeName.B, MediaSizeName.NA_LETTER, MediaSizeName.NA_NUMBER_9_ENVELOPE, MediaSizeName.NA_NUMBER_10_ENVELOPE, MediaSizeName.NA_NUMBER_11_ENVELOPE, MediaSizeName.NA_NUMBER_12_ENVELOPE, MediaSizeName.NA_NUMBER_14_ENVELOPE, MediaSizeName.C, MediaSizeName.D, MediaSizeName.E, MediaSizeName.ISO_DESIGNATED_LONG, MediaSizeName.ISO_C5, MediaSizeName.ISO_C3, MediaSizeName.ISO_C4, MediaSizeName.ISO_C6, MediaSizeName.ITALY_ENVELOPE, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5, MediaSizeName.ISO_B6, MediaSizeName.ITALY_ENVELOPE, MediaSizeName.MONARCH_ENVELOPE, MediaSizeName.PERSONAL_ENVELOPE, MediaSizeName.NA_10X15_ENVELOPE, MediaSizeName.NA_9X12_ENVELOPE, MediaSizeName.FOLIO, MediaSizeName.ISO_B4, MediaSizeName.JAPANESE_POSTCARD, MediaSizeName.NA_9X11_ENVELOPE};
        dmPaperBinToPrintService = new MediaTray[]{MediaTray.TOP, MediaTray.BOTTOM, MediaTray.MIDDLE, MediaTray.MANUAL, MediaTray.ENVELOPE, Win32MediaTray.ENVELOPE_MANUAL, Win32MediaTray.AUTO, Win32MediaTray.TRACTOR, Win32MediaTray.SMALL_FORMAT, Win32MediaTray.LARGE_FORMAT, MediaTray.LARGE_CAPACITY, null, null, MediaTray.MAIN, Win32MediaTray.FORMSOURCE};
        DM_PAPERSIZE = 2;
        DM_PRINTQUALITY = 1024;
        DM_YRESOLUTION = 8192;
    }
}

