/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import sun.nio.ch.AbstractPollArrayWrapper;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.IOUtil;
import sun.nio.ch.SelChImpl;

class PollArrayWrapper
extends AbstractPollArrayWrapper {
    static final short SIZE_WSAEVENT = 4;
    private AllocatedNativeObject eventArray;
    private long eventArrayAddress;
    boolean interrupted = false;

    PollArrayWrapper(int n2) {
        int n3 = n2 * 8;
        this.pollArray = new AllocatedNativeObject(n3, true);
        this.pollArrayAddress = this.pollArray.address();
        n3 = (n2 + 1) * 4;
        this.eventArray = new AllocatedNativeObject(n3, true);
        this.eventArrayAddress = this.eventArray.address();
    }

    void putEventOps(int n2, int n3) {
        int n4 = 8 * n2 + 4;
        this.pollArray.putShort(n4, (short)n3);
        this.setEntry(this.pollArrayAddress, this.eventArrayAddress, n2);
    }

    void addEntry(SelChImpl selChImpl) {
        if (this.totalChannels >= 64) {
            throw new UnsupportedOperationException("Implementation allows only 63 channels per Selector");
        }
        this.createEntry(this.eventArrayAddress, this.totalChannels);
        this.putDescriptor(this.totalChannels, IOUtil.fdVal(selChImpl.getFD()));
        this.putEventOps(this.totalChannels, 0);
        this.putReventOps(this.totalChannels, 0);
        ++this.totalChannels;
    }

    void release(int n2) {
        this.releaseEntry(this.pollArrayAddress, this.eventArrayAddress, n2);
    }

    void interrupt() {
        this.signalInterrupt(this.eventArrayAddress);
    }

    void initInterrupt() {
        this.createInterrupt(this.eventArrayAddress);
    }

    void releaseInterrupt() {
        this.releaseInterrupt(this.eventArrayAddress);
    }

    static void replaceEntry(PollArrayWrapper pollArrayWrapper, int n2, PollArrayWrapper pollArrayWrapper2, int n3) {
        int n4 = 4 * (n2 + 1);
        int n5 = pollArrayWrapper.eventArray.getInt(n4);
        n4 = 4 * (n3 + 1);
        pollArrayWrapper2.eventArray.putInt(n4, n5);
        pollArrayWrapper2.putDescriptor(n3, pollArrayWrapper.getDescriptor(n2));
        pollArrayWrapper2.putEventOps(n3, pollArrayWrapper.getEventOps(n2));
        pollArrayWrapper2.putReventOps(n3, pollArrayWrapper.getReventOps(n2));
    }

    static void replaceEventEntry(PollArrayWrapper pollArrayWrapper, int n2, PollArrayWrapper pollArrayWrapper2, int n3) {
        int n4 = 4 * n2;
        int n5 = pollArrayWrapper.eventArray.getInt(n4);
        n4 = 4 * n3;
        pollArrayWrapper2.eventArray.putInt(n4, n5);
    }

    void grow(int n2) {
        PollArrayWrapper pollArrayWrapper = new PollArrayWrapper(n2);
        int n3 = 0;
        while (n3 < this.totalChannels) {
            PollArrayWrapper.replaceEntry(this, n3, pollArrayWrapper, n3);
            ++n3;
        }
        PollArrayWrapper.replaceEventEntry(this, 0, pollArrayWrapper, 0);
        this.pollArray.free();
        this.pollArray = pollArrayWrapper.pollArray;
        this.pollArrayAddress = this.pollArray.address();
        this.eventArray.free();
        this.eventArray = pollArrayWrapper.eventArray;
        this.eventArrayAddress = this.eventArray.address();
    }

    int poll(int n2, long l2) {
        int n3 = this.poll0(this.pollArrayAddress, this.eventArrayAddress, n2 + 1, l2);
        if (n3 == 1) {
            this.interrupted = true;
        }
        return n3;
    }

    boolean interrupted() {
        return this.interrupted;
    }

    void clearInterrupted() {
        this.interrupted = false;
    }

    private native int poll0(long var1, long var3, int var5, long var6);

    private native void createEntry(long var1, int var3);

    private native void setEntry(long var1, long var3, int var5);

    private native void releaseEntry(long var1, long var3, int var5);

    private native void releaseInterrupt(long var1);

    private native void createInterrupt(long var1);

    private native void signalInterrupt(long var1);
}

