/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.peer.ListPeer;
import java.io.Serializable;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WToolkit;

class WListPeer
extends WComponentPeer
implements ListPeer {
    private FontMetrics fm;

    public Dimension minimumSize() {
        return this.minimumSize(4);
    }

    public boolean isFocusable() {
        return true;
    }

    public int[] getSelectedIndexes() {
        List list = (List)this.target;
        int n2 = list.countItems();
        int[] nArray = new int[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (this.isSelected(n4)) {
                nArray[n3++] = n4;
            }
            ++n4;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    public void add(String string, int n2) {
        this.addItem(string, n2);
    }

    public void removeAll() {
        this.clear();
    }

    public void setMultipleMode(boolean bl2) {
        this.setMultipleSelections(bl2);
    }

    public Dimension getPreferredSize(int n2) {
        return this.preferredSize(n2);
    }

    public Dimension getMinimumSize(int n2) {
        return this.minimumSize(n2);
    }

    public void addItem(String string, int n2) {
        this.addItems(new String[]{string}, n2, this.fm.stringWidth(string));
    }

    native void addItems(String[] var1, int var2, int var3);

    public native void delItems(int var1, int var2);

    public void clear() {
        List list = (List)this.target;
        this.delItems(0, list.countItems());
    }

    public native void select(int var1);

    public native void deselect(int var1);

    public native void makeVisible(int var1);

    public native void setMultipleSelections(boolean var1);

    public native int getMaxWidth();

    public Dimension preferredSize(int n2) {
        Serializable serializable;
        if (this.fm == null) {
            serializable = (List)this.target;
            this.fm = this.getFontMetrics(((Component)serializable).getFont());
        }
        serializable = this.minimumSize(n2);
        ((Dimension)serializable).width = Math.max(((Dimension)serializable).width, this.getMaxWidth() + 20);
        return serializable;
    }

    public Dimension minimumSize(int n2) {
        return new Dimension(20 + this.fm.stringWidth("0123456789abcde"), this.fm.getHeight() * n2 + 4);
    }

    WListPeer(List list) {
        super(list);
    }

    native void create(WComponentPeer var1);

    void initialize() {
        int n2;
        List list = (List)this.target;
        this.fm = this.getFontMetrics(list.getFont());
        int n3 = list.countItems();
        if (n3 > 0) {
            String[] stringArray = new String[n3];
            int n4 = 0;
            n2 = 0;
            int n5 = 0;
            while (n5 < n3) {
                stringArray[n5] = list.getItem(n5);
                n2 = this.fm.stringWidth(stringArray[n5]);
                if (n2 > n4) {
                    n4 = n2;
                }
                ++n5;
            }
            this.addItems(stringArray, 0, n4);
        }
        this.setMultipleSelections(list.allowsMultipleSelections());
        int n6 = list.getVisibleIndex();
        if (n6 >= 0) {
            this.makeVisible(n6);
        }
        int[] nArray = list.getSelectedIndexes();
        n2 = 0;
        while (n2 < nArray.length) {
            this.select(nArray[n2]);
            ++n2;
        }
        super.initialize();
    }

    public boolean shouldClearRectBeforePaint() {
        return false;
    }

    private native void updateMaxItemWidth();

    native boolean isSelected(int var1);

    public synchronized void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(((List)this.target).getFont());
        this.updateMaxItemWidth();
    }

    void handleAction(final int n2, final long l2, final int n3) {
        final List list = (List)this.target;
        WToolkit.executeOnEventHandlerThread(list, new Runnable(){

            public void run() {
                list.select(n2);
                WListPeer.this.postEvent(new ActionEvent(WListPeer.this.target, 1001, list.getItem(n2), l2, n3));
            }
        });
    }

    void handleListChanged(final int n2) {
        final List list = (List)this.target;
        WToolkit.executeOnEventHandlerThread(list, new Runnable(){

            public void run() {
                WListPeer.this.postEvent(new ItemEvent(list, 701, new Integer(n2), WListPeer.this.isSelected(n2) ? 1 : 2));
            }
        });
    }
}

