/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import sun.awt.EmbeddedFrame;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.windows.WToolkit;

public class WEmbeddedFrame
extends EmbeddedFrame {
    private int handle;
    private int bandWidth = 0;
    private int bandHeight = 0;
    private BufferedImage bandImage = null;
    private static final int MAX_BAND_SIZE = 786432;

    public WEmbeddedFrame() {
        this(0);
    }

    public WEmbeddedFrame(int n2) {
        this.handle = n2;
        WToolkit wToolkit = (WToolkit)Toolkit.getDefaultToolkit();
        this.setPeer(wToolkit.createEmbeddedFrame(this));
        this.show();
    }

    void print(int n2) {
        int n3 = this.getHeight();
        if (this.bandImage == null) {
            this.bandWidth = this.getWidth();
            if (this.bandWidth % 4 != 0) {
                this.bandWidth += 4 - this.bandWidth % 4;
            }
            if (this.bandWidth <= 0) {
                return;
            }
            this.bandHeight = Math.min(786432 / this.bandWidth, n3);
            this.bandImage = new BufferedImage(this.bandWidth, this.bandHeight, 5);
        }
        Graphics graphics = this.bandImage.getGraphics();
        graphics.setColor(Color.white);
        Graphics graphics2 = this.bandImage.getGraphics();
        ByteInterleavedRaster byteInterleavedRaster = (ByteInterleavedRaster)this.bandImage.getRaster();
        byte[] byArray = byteInterleavedRaster.getDataStorage();
        int n4 = 0;
        while (n4 < n3) {
            graphics.fillRect(0, 0, this.bandWidth, this.bandHeight);
            this.printComponents(graphics2);
            int n5 = this.bandHeight;
            if (n4 + this.bandHeight > n3) {
                n5 = n3 - n4;
            }
            this.printBand(n2, byArray, 0, n4, this.bandWidth, n5);
            graphics2.translate(0, -this.bandHeight);
            n4 += this.bandHeight;
        }
    }

    protected native void printBand(long var1, byte[] var3, int var4, int var5, int var6, int var7);

    private static native void initIDs();

    static {
        WEmbeddedFrame.initIDs();
    }
}

