/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.datatransfer;

import java.awt.AWTError;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.rmi.MarshalledObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import sun.awt.AppContext;
import sun.awt.DebugHelper;
import sun.awt.SunToolkit;
import sun.awt.datatransfer.ToolkitThreadBlockedHandler;
import sun.io.CharToByteConverter;
import sun.io.CharacterEncoding;
import sun.security.action.GetPropertyAction;

public abstract class DataTransferer {
    private static final DebugHelper dbg = DebugHelper.create(class$sun$awt$datatransfer$DataTransferer == null ? (class$sun$awt$datatransfer$DataTransferer = DataTransferer.class$("sun.awt.datatransfer.DataTransferer")) : class$sun$awt$datatransfer$DataTransferer);
    public static final Class charArrayClass;
    public static final Class byteArrayClass;
    public static final DataFlavor plainTextStringFlavor;
    public static final DataFlavor javaTextEncodingFlavor;
    private static SortedSet standardEncodings;
    private static final Map knownEncodings;
    private static final Map textMIMESubtypeCharsetSupport;
    private static String defaultEncoding;
    private static final Set textNatives;
    private static final Map nativeCharsets;
    private static final Map nativeEOLNs;
    private static final Map nativeTerminators;
    private static DataTransferer transferer;
    private static final DirectColorModel directColorModel;
    private static final int[] bandmasks;
    private static final Map blockedEventQueues;
    private static CharsetComparator defaultCharsetComparator;
    private static DataFlavorComparator defaultFlavorComparator;
    static /* synthetic */ Class class$sun$awt$datatransfer$DataTransferer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$nio$CharBuffer;
    static /* synthetic */ Class class$java$nio$ByteBuffer;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$rmi$Remote;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataTransferer getInstance() {
        if (transferer == null) {
            Class clazz = class$sun$awt$datatransfer$DataTransferer == null ? (class$sun$awt$datatransfer$DataTransferer = DataTransferer.class$("sun.awt.datatransfer.DataTransferer")) : class$sun$awt$datatransfer$DataTransferer;
            synchronized (clazz) {
                String string;
                if (transferer == null && (string = SunToolkit.getDataTransfererClassName()) != null) {
                    PrivilegedAction privilegedAction = new PrivilegedAction(){

                        public Object run() {
                            Object object;
                            Method method;
                            Class clazz;
                            block11: {
                                clazz = null;
                                method = null;
                                object = null;
                                try {
                                    clazz = Class.forName(string);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                                    if (classLoader == null) break block11;
                                    try {
                                        clazz = classLoader.loadClass(string);
                                    }
                                    catch (ClassNotFoundException classNotFoundException2) {
                                        classNotFoundException2.printStackTrace();
                                        throw new AWTError("DataTransferer not found: " + string);
                                    }
                                }
                            }
                            if (clazz != null) {
                                try {
                                    method = clazz.getMethod("getInstanceImpl", null);
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    noSuchMethodException.printStackTrace();
                                    throw new AWTError("Cannot instantiate DataTransferer: " + string);
                                }
                            }
                            if (method != null) {
                                try {
                                    object = method.invoke(null, null);
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                    invocationTargetException.printStackTrace();
                                    throw new AWTError("Cannot instantiate DataTransferer: " + string);
                                }
                                catch (IllegalAccessException illegalAccessException) {
                                    illegalAccessException.printStackTrace();
                                    throw new AWTError("Cannot access DataTransferer: " + string);
                                }
                            }
                            return object;
                        }
                    };
                    transferer = (DataTransferer)AccessController.doPrivileged(privilegedAction);
                }
            }
        }
        return transferer;
    }

    public static String canonicalName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = CharacterEncoding.aliasName(string);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public static String getTextCharset(DataFlavor dataFlavor) {
        if (!DataTransferer.isFlavorCharsetTextType(dataFlavor)) {
            return null;
        }
        String string = dataFlavor.getParameter("charset");
        return string != null ? string : DataTransferer.getDefaultTextCharset();
    }

    public static String getDefaultTextCharset() {
        if (defaultEncoding != null) {
            return defaultEncoding;
        }
        GetPropertyAction getPropertyAction = new GetPropertyAction("file.encoding");
        String string = (String)AccessController.doPrivileged(getPropertyAction);
        if (string != null) {
            defaultEncoding = DataTransferer.canonicalName(string);
            if (!DataTransferer.isEncodingSupported(defaultEncoding)) {
                defaultEncoding = "ISO8859_1";
            }
            return defaultEncoding;
        }
        return "ISO8859_1";
    }

    public static boolean doesSubtypeSupportCharset(DataFlavor dataFlavor) {
        String string = dataFlavor.getSubType();
        if (string == null) {
            return false;
        }
        Object object = textMIMESubtypeCharsetSupport.get(string);
        if (object != null) {
            return object == Boolean.TRUE;
        }
        boolean bl2 = dataFlavor.getParameter("charset") != null;
        textMIMESubtypeCharsetSupport.put(string, bl2 ? Boolean.TRUE : Boolean.FALSE);
        return bl2;
    }

    public static boolean doesSubtypeSupportCharset(String string, String string2) {
        Object object = textMIMESubtypeCharsetSupport.get(string);
        if (object != null) {
            return object == Boolean.TRUE;
        }
        boolean bl2 = string2 != null;
        textMIMESubtypeCharsetSupport.put(string, bl2 ? Boolean.TRUE : Boolean.FALSE);
        return bl2;
    }

    public static boolean isFlavorCharsetTextType(DataFlavor dataFlavor) {
        if (DataFlavor.stringFlavor.equals(dataFlavor)) {
            return true;
        }
        if (!"text".equals(dataFlavor.getPrimaryType()) || !DataTransferer.doesSubtypeSupportCharset(dataFlavor)) {
            return false;
        }
        Class clazz = dataFlavor.getRepresentationClass();
        if (dataFlavor.isRepresentationClassReader() || (class$java$lang$String == null ? (class$java$lang$String = DataTransferer.class$("java.lang.String")) : class$java$lang$String).equals(clazz) || dataFlavor.isRepresentationClassCharBuffer() || charArrayClass.equals(clazz)) {
            return true;
        }
        if (!(dataFlavor.isRepresentationClassInputStream() || dataFlavor.isRepresentationClassByteBuffer() || byteArrayClass.equals(clazz))) {
            return false;
        }
        String string = dataFlavor.getParameter("charset");
        return string != null ? DataTransferer.isEncodingSupported(string) : true;
    }

    public static boolean isFlavorNoncharsetTextType(DataFlavor dataFlavor) {
        if (!"text".equals(dataFlavor.getPrimaryType()) || DataTransferer.doesSubtypeSupportCharset(dataFlavor)) {
            return false;
        }
        return dataFlavor.isRepresentationClassInputStream() || dataFlavor.isRepresentationClassByteBuffer() || byteArrayClass.equals(dataFlavor.getRepresentationClass());
    }

    public static boolean isEncodingSupported(String string) {
        if (string == null) {
            return false;
        }
        String string2 = DataTransferer.canonicalName(string);
        Boolean bl2 = (Boolean)knownEncodings.get(string2);
        if (bl2 == null) {
            try {
                new String("abc".getBytes(string2), string2);
                bl2 = Boolean.TRUE;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bl2 = Boolean.FALSE;
            }
            knownEncodings.put(string2, bl2);
        }
        return bl2 == Boolean.TRUE;
    }

    public static Iterator standardEncodings() {
        if (standardEncodings == null) {
            TreeSet treeSet = new TreeSet(defaultCharsetComparator);
            treeSet.add("US-ASCII");
            treeSet.add("ISO-8859-1");
            treeSet.add("UTF-8");
            treeSet.add("UTF-16BE");
            treeSet.add("UTF-16LE");
            treeSet.add("UTF-16");
            treeSet.add(DataTransferer.getDefaultTextCharset());
            standardEncodings = Collections.unmodifiableSortedSet(treeSet);
        }
        return standardEncodings.iterator();
    }

    public static FlavorTable adaptFlavorMap(final FlavorMap flavorMap) {
        if (flavorMap instanceof FlavorTable) {
            return (FlavorTable)flavorMap;
        }
        return new FlavorTable(){

            public Map getNativesForFlavors(DataFlavor[] dataFlavorArray) {
                return flavorMap.getNativesForFlavors(dataFlavorArray);
            }

            public Map getFlavorsForNatives(String[] stringArray) {
                return flavorMap.getFlavorsForNatives(stringArray);
            }

            public List getNativesForFlavor(DataFlavor dataFlavor) {
                Map map = this.getNativesForFlavors(new DataFlavor[]{dataFlavor});
                String string = (String)map.get(dataFlavor);
                if (string != null) {
                    ArrayList arrayList = new ArrayList(1);
                    arrayList.add(string);
                    return arrayList;
                }
                return Collections.EMPTY_LIST;
            }

            public List getFlavorsForNative(String string) {
                Map map = this.getFlavorsForNatives(new String[]{string});
                DataFlavor dataFlavor = (DataFlavor)map.get(string);
                if (dataFlavor != null) {
                    ArrayList arrayList = new ArrayList(1);
                    arrayList.add(dataFlavor);
                    return arrayList;
                }
                return Collections.EMPTY_LIST;
            }
        };
    }

    public abstract String getDefaultUnicodeEncoding();

    public void registerTextFlavorProperties(String string, String string2, String string3, String string4) {
        Integer n2;
        Long l2 = this.getFormatForNativeAsLong(string);
        textNatives.add(l2);
        nativeCharsets.put(l2, string2 != null && string2.length() != 0 ? string2 : DataTransferer.getDefaultTextCharset());
        if (string3 != null && string3.length() != 0 && !string3.equals("\n")) {
            nativeEOLNs.put(l2, string3);
        }
        if (string4 != null && string4.length() != 0 && (n2 = Integer.valueOf(string4)) > 0) {
            nativeTerminators.put(l2, n2);
        }
    }

    private boolean isTextFormat(long l2) {
        return textNatives.contains(new Long(l2));
    }

    public abstract boolean isLocaleDependentTextFormat(long var1);

    public abstract boolean isFileFormat(long var1);

    public abstract boolean isImageFormat(long var1);

    public Map getFormatsForTransferable(Transferable transferable, FlavorTable flavorTable) {
        return this.getFormatsForFlavors(transferable.getTransferDataFlavors(), flavorTable);
    }

    public Map getFormatsForFlavor(DataFlavor dataFlavor, FlavorTable flavorTable) {
        return this.getFormatsForFlavors(new DataFlavor[]{dataFlavor}, flavorTable);
    }

    public Map getFormatsForFlavors(DataFlavor[] dataFlavorArray, FlavorTable flavorTable) {
        HashMap hashMap = new HashMap(dataFlavorArray.length);
        HashMap hashMap2 = new HashMap(dataFlavorArray.length);
        int n2 = dataFlavorArray.length - 1;
        while (n2 >= 0) {
            DataFlavor dataFlavor = dataFlavorArray[n2];
            if (dataFlavor.isFlavorTextType() || dataFlavor.isFlavorJavaFileListType() || DataFlavor.imageFlavor.equals(dataFlavor) || dataFlavor.isRepresentationClassSerializable() || dataFlavor.isRepresentationClassInputStream() || dataFlavor.isRepresentationClassRemote()) {
                Object object;
                if (DataFlavor.imageFlavor.equals(dataFlavor)) {
                    object = this.getImageFormatsAsLongArray();
                    int n3 = 0;
                    while (n3 < ((Object)object).length) {
                        hashMap.put(object[n3], dataFlavor);
                        ++n3;
                    }
                }
                object = flavorTable.getNativesForFlavor(dataFlavor);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Long l2 = this.getFormatForNativeAsLong((String)iterator.next());
                    hashMap.put(l2, dataFlavor);
                    if ((!"text".equals(dataFlavor.getPrimaryType()) || !"plain".equals(dataFlavor.getSubType())) && !dataFlavor.equals(DataFlavor.stringFlavor)) continue;
                    hashMap2.put(l2, dataFlavor);
                }
            }
            --n2;
        }
        hashMap.putAll(hashMap2);
        return hashMap;
    }

    public long[] getFormatsForTransferableAsArray(Transferable transferable, FlavorTable flavorTable) {
        return DataTransferer.keysToLongArray(this.getFormatsForTransferable(transferable, flavorTable));
    }

    public long[] getFormatsForFlavorAsArray(DataFlavor dataFlavor, FlavorTable flavorTable) {
        return DataTransferer.keysToLongArray(this.getFormatsForFlavor(dataFlavor, flavorTable));
    }

    public long[] getFormatsForFlavorsAsArray(DataFlavor[] dataFlavorArray, FlavorTable flavorTable) {
        return DataTransferer.keysToLongArray(this.getFormatsForFlavors(dataFlavorArray, flavorTable));
    }

    public Map getFlavorsForFormat(long l2, FlavorTable flavorTable) {
        return this.getFlavorsForFormats(new long[]{l2}, flavorTable);
    }

    public Map getFlavorsForFormats(long[] lArray, FlavorTable flavorTable) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        HashMap hashMap = new HashMap(lArray.length);
        HashSet hashSet = new HashSet(lArray.length);
        HashSet hashSet2 = new HashSet(lArray.length);
        int n2 = 0;
        while (n2 < lArray.length) {
            long l2 = lArray[n2];
            object4 = this.getNativeForFormat(l2);
            object3 = flavorTable.getFlavorsForNative((String)object4);
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (DataFlavor)object2.next();
                if (!((DataFlavor)object).isFlavorTextType() && !((DataFlavor)object).isFlavorJavaFileListType() && !DataFlavor.imageFlavor.equals((DataFlavor)object) && !((DataFlavor)object).isRepresentationClassSerializable() && !((DataFlavor)object).isRepresentationClassInputStream() && !((DataFlavor)object).isRepresentationClassRemote()) continue;
                Long l3 = new Long(l2);
                Object object5 = DataTransferer.createMapping(l3, object);
                hashMap.put(object, l3);
                hashSet.add(object5);
                hashSet2.add(object);
            }
            ++n2;
        }
        Iterator iterator = hashSet2.iterator();
        block2: while (iterator.hasNext()) {
            DataFlavor dataFlavor = (DataFlavor)iterator.next();
            object4 = flavorTable.getNativesForFlavor(dataFlavor);
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = this.getFormatForNativeAsLong((String)object3.next());
                object = DataTransferer.createMapping(object2, dataFlavor);
                if (!hashSet.contains(object)) continue;
                hashMap.put(dataFlavor, object2);
                continue block2;
            }
        }
        return hashMap;
    }

    public Set getFlavorsForFormatsAsSet(long[] lArray, FlavorTable flavorTable) {
        HashSet hashSet = new HashSet(lArray.length);
        int n2 = 0;
        while (n2 < lArray.length) {
            String string = this.getNativeForFormat(lArray[n2]);
            List list = flavorTable.getFlavorsForNative(string);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DataFlavor dataFlavor = (DataFlavor)iterator.next();
                if (!dataFlavor.isFlavorTextType() && !dataFlavor.isFlavorJavaFileListType() && !DataFlavor.imageFlavor.equals(dataFlavor) && !dataFlavor.isRepresentationClassSerializable() && !dataFlavor.isRepresentationClassInputStream() && !dataFlavor.isRepresentationClassRemote()) continue;
                hashSet.add(dataFlavor);
            }
            ++n2;
        }
        return hashSet;
    }

    public DataFlavor[] getFlavorsForFormatAsArray(long l2, FlavorTable flavorTable) {
        return this.getFlavorsForFormatsAsArray(new long[]{l2}, flavorTable);
    }

    public DataFlavor[] getFlavorsForFormatsAsArray(long[] lArray, FlavorTable flavorTable) {
        return DataTransferer.setToSortedDataFlavorArray(this.getFlavorsForFormatsAsSet(lArray, flavorTable));
    }

    private static Object createMapping(Object object, Object object2) {
        return Arrays.asList(new Object[]{object, object2});
    }

    protected abstract Long[] getImageFormatsAsLongArray();

    protected abstract Long getFormatForNativeAsLong(String var1);

    protected abstract String getNativeForFormat(long var1);

    public byte[] translateTransferable(Transferable transferable, DataFlavor dataFlavor, long l2) throws IOException {
        Object object;
        boolean bl2;
        Object object2;
        try {
            object2 = transferable.getTransferData(dataFlavor);
            if (object2 == null) {
                return null;
            }
            if (dataFlavor.equals(DataFlavor.plainTextFlavor) && !(object2 instanceof InputStream)) {
                object2 = transferable.getTransferData(DataFlavor.stringFlavor);
                if (object2 == null) {
                    return null;
                }
                bl2 = true;
            } else {
                bl2 = false;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            throw new IOException(unsupportedFlavorException.getMessage());
        }
        if (bl2 || (class$java$lang$String == null ? (class$java$lang$String = DataTransferer.class$("java.lang.String")) : class$java$lang$String).equals(dataFlavor.getRepresentationClass()) && DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l2)) {
            int n2;
            String string = (String)object2;
            Long l3 = new Long(l2);
            String string2 = (String)nativeCharsets.get(l3);
            if (string2 == null) {
                string2 = DataTransferer.getDefaultTextCharset();
            }
            String string3 = (String)nativeEOLNs.get(l3);
            Integer n3 = (Integer)nativeTerminators.get(l3);
            if (string3 != null) {
                int n4 = string.length();
                StringBuffer stringBuffer = new StringBuffer(n4 * 2);
                int n5 = 0;
                while (n5 < n4) {
                    n2 = string.charAt(n5);
                    if (n2 == 10) {
                        stringBuffer.append(string3);
                    } else {
                        stringBuffer.append((char)n2);
                    }
                    ++n5;
                }
                string = stringBuffer.toString();
            }
            byte[] byArray = string.getBytes(string2);
            if (n3 != null) {
                int n6 = n3;
                byte[] byArray2 = new byte[byArray.length + n6];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                n2 = byArray.length;
                while (n2 < byArray2.length) {
                    byArray2[n2] = 0;
                    ++n2;
                }
                byArray = byArray2;
            }
            return byArray;
        }
        if (dataFlavor.isRepresentationClassReader()) {
            int n7;
            if (!DataTransferer.isFlavorCharsetTextType(dataFlavor) || !this.isTextFormat(l2)) {
                throw new IOException("cannot transfer non-text data as Reader");
            }
            Reader reader = (Reader)object2;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n7 = reader.read()) != -1) {
                stringBuffer.append((char)n7);
            }
            reader.close();
            return this.translateTransferable(new StringSelection(stringBuffer.toString()), DataFlavor.plainTextFlavor, l2);
        }
        if (dataFlavor.isRepresentationClassCharBuffer()) {
            if (!DataTransferer.isFlavorCharsetTextType(dataFlavor) || !this.isTextFormat(l2)) {
                throw new IOException("cannot transfer non-text data as CharBuffer");
            }
            CharBuffer charBuffer = (CharBuffer)object2;
            int n8 = charBuffer.remaining();
            char[] cArray = new char[n8];
            charBuffer.get(cArray, 0, n8);
            return this.translateTransferable(new StringSelection(new String(cArray)), DataFlavor.plainTextFlavor, l2);
        }
        if (charArrayClass.equals(dataFlavor.getRepresentationClass())) {
            if (!DataTransferer.isFlavorCharsetTextType(dataFlavor) || !this.isTextFormat(l2)) {
                throw new IOException("cannot transfer non-text data as char array");
            }
            return this.translateTransferable(new StringSelection(new String((char[])object2)), DataFlavor.plainTextFlavor, l2);
        }
        if (dataFlavor.isRepresentationClassByteBuffer()) {
            ByteBuffer byteBuffer = (ByteBuffer)object2;
            int n9 = byteBuffer.remaining();
            byte[] byArray = new byte[n9];
            byteBuffer.get(byArray, 0, n9);
            if (DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l2)) {
                String string = DataTransferer.getTextCharset(dataFlavor);
                return this.translateTransferable(new StringSelection(new String(byArray, string)), DataFlavor.plainTextFlavor, l2);
            }
            return byArray;
        }
        if (byteArrayClass.equals(dataFlavor.getRepresentationClass())) {
            byte[] byArray = (byte[])object2;
            if (DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l2)) {
                String string = DataTransferer.getTextCharset(dataFlavor);
                return this.translateTransferable(new StringSelection(new String(byArray, string)), DataFlavor.plainTextFlavor, l2);
            }
            return byArray;
        }
        if (DataFlavor.imageFlavor.equals(dataFlavor)) {
            if (!this.isImageFormat(l2)) {
                throw new IOException("Data translation failed: not an image format");
            }
            Image image = (Image)object2;
            byte[] byArray = this.imageToPlatformBytes(image, l2);
            if (byArray == null) {
                throw new IOException("Data translation failed: cannot convert java image to native format");
            }
            return byArray;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.isFileFormat(l2)) {
            Object object3;
            if (!DataFlavor.javaFileListFlavor.equals(dataFlavor)) {
                throw new IOException("data translation failed");
            }
            object = (List)object2;
            int n10 = 0;
            int n11 = 0;
            while (n11 < object.size()) {
                object3 = object.get(n11);
                if (object3 instanceof File || object3 instanceof String) {
                    ++n10;
                }
                ++n11;
            }
            object3 = new String[n10];
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction((List)object, (String[])object3){
                    private final /* synthetic */ List val$list;
                    private final /* synthetic */ String[] val$files;
                    {
                        this.val$list = list;
                        this.val$files = stringArray;
                    }

                    public Object run() throws IOException {
                        int n2 = 0;
                        int n3 = 0;
                        while (n2 < this.val$list.size()) {
                            Object object = this.val$list.get(n2);
                            if (object instanceof File) {
                                this.val$files[n3++] = ((File)object).getCanonicalPath();
                            } else if (object instanceof String) {
                                this.val$files[n3++] = (String)object;
                            }
                            ++n2;
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new IOException(privilegedActionException.getMessage());
            }
            int n12 = 0;
            while (n12 < ((String[])object3).length) {
                byte[] byArray = object3[n12].getBytes();
                byteArrayOutputStream.write(byArray, 0, byArray.length);
                byteArrayOutputStream.write(0);
                ++n12;
            }
            byteArrayOutputStream.write(0);
        } else if (dataFlavor.isRepresentationClassInputStream()) {
            object = (InputStream)object2;
            boolean bl3 = false;
            int n13 = ((InputStream)object).available();
            byte[] byArray = new byte[n13 > 8192 ? n13 : 8192];
            do {
                int n14;
                if (bl3 = (n14 = ((InputStream)object).read(byArray, 0, byArray.length)) == -1) continue;
                byteArrayOutputStream.write(byArray, 0, n14);
            } while (!bl3);
            ((InputStream)object).close();
            if (DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l2)) {
                byte[] byArray3 = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                String string = DataTransferer.getTextCharset(dataFlavor);
                return this.translateTransferable(new StringSelection(new String(byArray3, string)), DataFlavor.plainTextFlavor, l2);
            }
        } else if (dataFlavor.isRepresentationClassRemote()) {
            object = new MarshalledObject(object2);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
        } else if (dataFlavor.isRepresentationClassSerializable()) {
            object = new ObjectOutputStream(byteArrayOutputStream);
            ((ObjectOutputStream)object).writeObject(object2);
            ((ObjectOutputStream)object).close();
        } else {
            throw new IOException("data translation failed");
        }
        object = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return object;
    }

    public Object translateBytes(byte[] byArray, DataFlavor dataFlavor, long l2, Transferable transferable) throws IOException {
        return this.translateBytesOrStream(null, byArray, dataFlavor, l2, transferable);
    }

    public Object translateStream(InputStream inputStream, DataFlavor dataFlavor, long l2, Transferable transferable) throws IOException {
        return this.translateBytesOrStream(inputStream, null, dataFlavor, l2, transferable);
    }

    protected Object translateBytesOrStream(InputStream inputStream, byte[] byArray, DataFlavor dataFlavor, long l2, Transferable transferable) throws IOException {
        if (inputStream == null) {
            inputStream = new ByteArrayInputStream(byArray);
        }
        if (this.isFileFormat(l2)) {
            String[] stringArray;
            if (!DataFlavor.javaFileListFlavor.equals(dataFlavor)) {
                throw new IOException("data translation failed");
            }
            if (byArray == null) {
                byArray = DataTransferer.inputStreamToByteArray(inputStream);
            }
            if ((stringArray = this.dragQueryFile(byArray)) == null) {
                inputStream.close();
                return null;
            }
            Object[] objectArray = new File[stringArray.length];
            int n2 = 0;
            while (n2 < stringArray.length) {
                objectArray[n2] = new File(stringArray[n2]);
                ++n2;
            }
            inputStream.close();
            return Arrays.asList(objectArray);
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = DataTransferer.class$("java.lang.String")) : class$java$lang$String).equals(dataFlavor.getRepresentationClass()) && DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l2)) {
            int n3;
            if (byArray == null) {
                byArray = DataTransferer.inputStreamToByteArray(inputStream);
            }
            inputStream.close();
            Long l3 = new Long(l2);
            String string = null;
            if (this.isLocaleDependentTextFormat(l2) && transferable != null && transferable.isDataFlavorSupported(javaTextEncodingFlavor)) {
                try {
                    string = new String((byte[])transferable.getTransferData(javaTextEncodingFlavor), "UTF-8");
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {}
            } else {
                string = (String)nativeCharsets.get(l3);
            }
            if (string == null) {
                string = DataTransferer.getDefaultTextCharset();
            }
            String string2 = (String)nativeEOLNs.get(l3);
            Integer n4 = (Integer)nativeTerminators.get(l3);
            if (n4 != null) {
                int n5 = n4;
                n3 = 0;
                block7: while (n3 < byArray.length - n5 + 1) {
                    int n6 = n3;
                    while (n6 < n3 + n5) {
                        if (byArray[n6] == 0) {
                            ++n6;
                            continue;
                        }
                        n3 += n5;
                        continue block7;
                    }
                    break;
                }
            } else {
                n3 = byArray.length;
            }
            String string3 = new String(byArray, 0, n3, string);
            if (string2 != null) {
                char[] cArray = string3.toCharArray();
                char[] cArray2 = string2.toCharArray();
                string3 = null;
                int n7 = 0;
                int n8 = 0;
                while (n8 < cArray.length) {
                    if (n8 + cArray2.length > cArray.length) {
                        cArray[n7++] = cArray[n8++];
                        continue;
                    }
                    boolean bl2 = true;
                    int n9 = 0;
                    int n10 = n8;
                    while (n9 < cArray2.length) {
                        if (cArray2[n9] != cArray[n10]) {
                            bl2 = false;
                            break;
                        }
                        ++n9;
                        ++n10;
                    }
                    if (bl2) {
                        cArray[n7++] = 10;
                        n8 += cArray2.length;
                        continue;
                    }
                    cArray[n7++] = cArray[n8++];
                }
                string3 = new String(cArray, 0, n7);
            }
            return string3;
        }
        if (DataFlavor.plainTextFlavor.equals(dataFlavor)) {
            return new StringReader((String)this.translateBytesOrStream(inputStream, byArray, plainTextStringFlavor, l2, transferable));
        }
        if (dataFlavor.isRepresentationClassInputStream()) {
            return this.translateBytesOrStreamToInputStream(inputStream, dataFlavor, l2, transferable);
        }
        if (dataFlavor.isRepresentationClassReader()) {
            if (!DataTransferer.isFlavorCharsetTextType(dataFlavor) || !this.isTextFormat(l2)) {
                throw new IOException("cannot transfer non-text data as Reader");
            }
            InputStream inputStream2 = (InputStream)this.translateBytesOrStreamToInputStream(inputStream, DataFlavor.plainTextFlavor, l2, transferable);
            String string = DataTransferer.getTextCharset(DataFlavor.plainTextFlavor);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream2, string);
            return this.constructFlavoredObject(inputStreamReader, dataFlavor, class$java$io$Reader == null ? (class$java$io$Reader = DataTransferer.class$("java.io.Reader")) : class$java$io$Reader);
        }
        if (dataFlavor.isRepresentationClassCharBuffer()) {
            if (!DataTransferer.isFlavorCharsetTextType(dataFlavor) || !this.isTextFormat(l2)) {
                throw new IOException("cannot transfer non-text data as CharBuffer");
            }
            CharBuffer charBuffer = CharBuffer.wrap((String)this.translateBytesOrStream(inputStream, byArray, plainTextStringFlavor, l2, transferable));
            return this.constructFlavoredObject(charBuffer, dataFlavor, class$java$nio$CharBuffer == null ? (class$java$nio$CharBuffer = DataTransferer.class$("java.nio.CharBuffer")) : class$java$nio$CharBuffer);
        }
        if (charArrayClass.equals(dataFlavor.getRepresentationClass())) {
            if (!DataTransferer.isFlavorCharsetTextType(dataFlavor) || !this.isTextFormat(l2)) {
                throw new IOException("cannot transfer non-text data as char array");
            }
            return ((String)this.translateBytesOrStream(inputStream, byArray, plainTextStringFlavor, l2, transferable)).toCharArray();
        }
        if (dataFlavor.isRepresentationClassByteBuffer()) {
            if (DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l2)) {
                byArray = ((String)this.translateBytesOrStream(inputStream, byArray, plainTextStringFlavor, l2, transferable)).getBytes(DataTransferer.getTextCharset(dataFlavor));
            } else if (byArray == null) {
                byArray = DataTransferer.inputStreamToByteArray(inputStream);
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            return this.constructFlavoredObject(byteBuffer, dataFlavor, class$java$nio$ByteBuffer == null ? (class$java$nio$ByteBuffer = DataTransferer.class$("java.nio.ByteBuffer")) : class$java$nio$ByteBuffer);
        }
        if (byteArrayClass.equals(dataFlavor.getRepresentationClass())) {
            if (DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l2)) {
                return ((String)this.translateBytesOrStream(inputStream, byArray, plainTextStringFlavor, l2, transferable)).getBytes(DataTransferer.getTextCharset(dataFlavor));
            }
            return byArray != null ? byArray : DataTransferer.inputStreamToByteArray(inputStream);
        }
        if (dataFlavor.isRepresentationClassRemote()) {
            try {
                byte[] byArray2 = DataTransferer.inputStreamToByteArray(inputStream);
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray2));
                Object object = ((MarshalledObject)objectInputStream.readObject()).get();
                objectInputStream.close();
                inputStream.close();
                return object;
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }
        if (dataFlavor.isRepresentationClassSerializable()) {
            try {
                byte[] byArray3 = DataTransferer.inputStreamToByteArray(inputStream);
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray3));
                Object object = objectInputStream.readObject();
                objectInputStream.close();
                inputStream.close();
                return object;
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }
        if (DataFlavor.imageFlavor.equals(dataFlavor)) {
            int[] nArray;
            if (!this.isImageFormat(l2)) {
                throw new IOException("data translation failed");
            }
            if (byArray == null) {
                byArray = DataTransferer.inputStreamToByteArray(inputStream);
                inputStream.close();
            }
            if ((nArray = this.platformImageBytesToImageData(byArray, l2)) == null) {
                throw new IOException("data translation failed");
            }
            int n11 = nArray.length - 2;
            int n12 = nArray[n11];
            int n13 = nArray[n11 + 1];
            DataBufferInt dataBufferInt = new DataBufferInt(nArray, n11);
            WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, n12, n13, n12, bandmasks, null);
            return new BufferedImage(directColorModel, writableRaster, false, null);
        }
        throw new IOException("data translation failed");
    }

    private Object translateBytesOrStreamToInputStream(InputStream inputStream, DataFlavor dataFlavor, long l2, Transferable transferable) throws IOException {
        if (DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l2)) {
            inputStream = new ReencodingInputStream(inputStream, l2, DataTransferer.getTextCharset(dataFlavor), transferable);
        }
        return this.constructFlavoredObject(inputStream, dataFlavor, class$java$io$InputStream == null ? (class$java$io$InputStream = DataTransferer.class$("java.io.InputStream")) : class$java$io$InputStream);
    }

    private Object constructFlavoredObject(Object object, DataFlavor dataFlavor, Class clazz) throws IOException {
        final Class clazz2 = dataFlavor.getRepresentationClass();
        if (clazz.equals(clazz2)) {
            return object;
        }
        Constructor[] constructorArray = null;
        try {
            constructorArray = (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return clazz2.getConstructors();
                }
            });
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.getMessage());
        }
        Constructor constructor = null;
        int n2 = 0;
        while (n2 < constructorArray.length) {
            Class[] classArray;
            if (Modifier.isPublic(constructorArray[n2].getModifiers()) && (classArray = constructorArray[n2].getParameterTypes()) != null && classArray.length == 1 && clazz.equals(classArray[0])) {
                constructor = constructorArray[n2];
                break;
            }
            ++n2;
        }
        if (constructor == null) {
            throw new IOException("can't find <init>(L" + clazz + ";)V for class: " + clazz2.getName());
        }
        try {
            return constructor.newInstance(new Object[]{object});
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private native String[] dragQueryFile(byte[] var1);

    private native int[] platformImageBytesToImageData(byte[] var1, long var2);

    protected abstract byte[] imageToPlatformBytes(Image var1, long var2);

    private Object concatData(Object object, Object object2) {
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (object2 instanceof byte[]) {
                byte[] byArray2 = (byte[])object2;
                byte[] byArray3 = new byte[byArray.length + byArray2.length];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
                return byArray3;
            }
            inputStream = new ByteArrayInputStream(byArray);
            inputStream2 = (InputStream)object2;
        } else {
            inputStream = (InputStream)object;
            inputStream2 = object2 instanceof byte[] ? new ByteArrayInputStream((byte[])object2) : (InputStream)object2;
        }
        return new SequenceInputStream(inputStream, inputStream2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlockedMode(boolean bl2) {
        EventQueue eventQueue = (EventQueue)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                AppContext appContext;
                if (EventQueue.isDispatchThread() && (appContext = AppContext.getAppContext()) != null) {
                    return appContext.get(AppContext.EVENT_QUEUE_KEY);
                }
                return null;
            }
        });
        if (eventQueue != null) {
            try {
                this.getToolkitThreadBlockedHandler().lock();
                if (bl2) {
                    Runnable runnable = (Runnable)blockedEventQueues.get(eventQueue);
                    if (runnable != null) {
                        runnable.run();
                    }
                    blockedEventQueues.put(eventQueue, null);
                } else {
                    blockedEventQueues.remove(eventQueue);
                }
                Object var5_4 = null;
                this.getToolkitThreadBlockedHandler().unlock();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.getToolkitThreadBlockedHandler().unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] convertData(Object object, final Transferable transferable, final long l2, final Map map, boolean bl2) throws IOException {
        byte[] byArray = null;
        if (bl2) {
            AppContext appContext = SunToolkit.targetToAppContext(object);
            if (appContext != null) {
                EventQueue eventQueue = (EventQueue)appContext.get(AppContext.EVENT_QUEUE_KEY);
                try {
                    this.getToolkitThreadBlockedHandler().lock();
                    if (eventQueue != null && !blockedEventQueues.containsKey(eventQueue)) {
                        final Stack stack = new Stack();
                        Runnable runnable = new Runnable(){
                            private boolean done = false;

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                if (this.done) {
                                    return;
                                }
                                byte[] byArray = null;
                                try {
                                    DataFlavor dataFlavor = (DataFlavor)map.get(new Long(l2));
                                    if (dataFlavor != null) {
                                        byArray = DataTransferer.this.translateTransferable(transferable, dataFlavor, l2);
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    byArray = null;
                                }
                                try {
                                    DataTransferer.this.getToolkitThreadBlockedHandler().lock();
                                    stack.push(byArray);
                                    DataTransferer.this.getToolkitThreadBlockedHandler().exit();
                                    Object var4_4 = null;
                                    this.done = true;
                                    DataTransferer.this.getToolkitThreadBlockedHandler().unlock();
                                }
                                catch (Throwable throwable) {
                                    Object var4_5 = null;
                                    this.done = true;
                                    DataTransferer.this.getToolkitThreadBlockedHandler().unlock();
                                    throw throwable;
                                }
                            }
                        };
                        blockedEventQueues.put(eventQueue, runnable);
                        SunToolkit.executeOnEventHandlerThread(object, runnable);
                        while (stack.empty()) {
                            this.getToolkitThreadBlockedHandler().enter();
                        }
                        blockedEventQueues.remove(eventQueue);
                        byArray = (byte[])stack.pop();
                    }
                    Object var13_12 = null;
                    this.getToolkitThreadBlockedHandler().unlock();
                }
                catch (Throwable throwable) {
                    Object var13_13 = null;
                    this.getToolkitThreadBlockedHandler().unlock();
                    throw throwable;
                }
            }
        } else {
            DataFlavor dataFlavor = (DataFlavor)map.get(new Long(l2));
            if (dataFlavor != null) {
                byArray = this.translateTransferable(transferable, dataFlavor, l2);
            }
        }
        return byArray;
    }

    public abstract ToolkitThreadBlockedHandler getToolkitThreadBlockedHandler();

    public static long[] keysToLongArray(Map map) {
        Set set = map.keySet();
        long[] lArray = new long[set.size()];
        int n2 = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            lArray[n2] = (Long)iterator.next();
            ++n2;
        }
        return lArray;
    }

    public static DataFlavor[] keysToDataFlavorArray(Map map) {
        return DataTransferer.setToSortedDataFlavorArray(map.keySet(), map);
    }

    public static DataFlavor[] setToSortedDataFlavorArray(Set set) {
        Object[] objectArray = new DataFlavor[set.size()];
        set.toArray(objectArray);
        Arrays.sort(objectArray, defaultFlavorComparator);
        return objectArray;
    }

    public static DataFlavor[] setToSortedDataFlavorArray(Set set, Map map) {
        Object[] objectArray = new DataFlavor[set.size()];
        set.toArray(objectArray);
        DataFlavorComparator dataFlavorComparator = new DataFlavorComparator(map, false);
        Arrays.sort(objectArray, dataFlavorComparator);
        return objectArray;
    }

    protected static byte[] inputStreamToByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        byte[] byArray = new byte[8192];
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        textNatives = Collections.synchronizedSet(new HashSet());
        nativeCharsets = Collections.synchronizedMap(new HashMap());
        nativeEOLNs = Collections.synchronizedMap(new HashMap());
        nativeTerminators = Collections.synchronizedMap(new HashMap());
        directColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        bandmasks = new int[]{directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask()};
        blockedEventQueues = new IdentityHashMap();
        Class clazz = null;
        Class clazz2 = null;
        try {
            clazz = Class.forName("[C");
            clazz2 = Class.forName("[B");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        charArrayClass = clazz;
        byteArrayClass = clazz2;
        DataFlavor dataFlavor = null;
        try {
            dataFlavor = new DataFlavor("text/plain;charset=Unicode;class=java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        plainTextStringFlavor = dataFlavor;
        DataFlavor dataFlavor2 = null;
        try {
            dataFlavor2 = new DataFlavor("application/x-java-text-encoding;class=\"[B\"");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        javaTextEncodingFlavor = dataFlavor2;
        HashMap hashMap = new HashMap(11);
        hashMap.put("ASCII", Boolean.TRUE);
        hashMap.put("ISO8859_1", Boolean.TRUE);
        hashMap.put("UTF8", Boolean.TRUE);
        hashMap.put("UnicodeBigUnmarked", Boolean.TRUE);
        hashMap.put("UnicodeLittleUnmarked", Boolean.TRUE);
        hashMap.put("UTF16", Boolean.TRUE);
        knownEncodings = Collections.synchronizedMap(hashMap);
        hashMap = new HashMap(17);
        hashMap.put("sgml", Boolean.TRUE);
        hashMap.put("xml", Boolean.TRUE);
        hashMap.put("html", Boolean.TRUE);
        hashMap.put("enriched", Boolean.TRUE);
        hashMap.put("richtext", Boolean.TRUE);
        hashMap.put("uri-list", Boolean.TRUE);
        hashMap.put("directory", Boolean.TRUE);
        hashMap.put("css", Boolean.TRUE);
        hashMap.put("calendar", Boolean.TRUE);
        hashMap.put("plain", Boolean.TRUE);
        hashMap.put("rtf", Boolean.FALSE);
        hashMap.put("tab-separated-values", Boolean.FALSE);
        hashMap.put("t140", Boolean.FALSE);
        hashMap.put("rfc822-headers", Boolean.FALSE);
        hashMap.put("parityfec", Boolean.FALSE);
        textMIMESubtypeCharsetSupport = Collections.synchronizedMap(hashMap);
        defaultCharsetComparator = new CharsetComparator(false);
        defaultFlavorComparator = new DataFlavorComparator(false);
    }

    public static class DataFlavorComparator
    extends IndexedComparator {
        protected final Map flavorToFormatMap;
        private final CharsetComparator charsetComparator;
        private static final Map exactTypes;
        private static final Map primaryTypes;
        private static final Map nonTextRepresentations;
        private static final Map textTypes;
        private static final Map decodedTextRepresentations;
        private static final Map encodedTextRepresentations;
        private static final Integer UNKNOWN_OBJECT_LOSES;
        private static final Integer UNKNOWN_OBJECT_WINS;
        private static final Long UNKNOWN_OBJECT_LOSES_L;
        private static final Long UNKNOWN_OBJECT_WINS_L;

        public DataFlavorComparator() {
            this(true);
        }

        public DataFlavorComparator(boolean bl2) {
            super(bl2);
            this.charsetComparator = new CharsetComparator(bl2);
            this.flavorToFormatMap = Collections.EMPTY_MAP;
        }

        public DataFlavorComparator(Map map) {
            this(map, true);
        }

        public DataFlavorComparator(Map map, boolean bl2) {
            super(bl2);
            this.charsetComparator = new CharsetComparator(bl2);
            HashMap hashMap = new HashMap(map.size());
            hashMap.putAll(map);
            this.flavorToFormatMap = Collections.unmodifiableMap(hashMap);
        }

        public int compare(Object object, Object object2) {
            DataFlavor dataFlavor = null;
            DataFlavor dataFlavor2 = null;
            if (this.order) {
                dataFlavor = (DataFlavor)object;
                dataFlavor2 = (DataFlavor)object2;
            } else {
                dataFlavor = (DataFlavor)object2;
                dataFlavor2 = (DataFlavor)object;
            }
            if (dataFlavor.equals(dataFlavor2)) {
                return 0;
            }
            int n2 = 0;
            String string = dataFlavor.getPrimaryType();
            String string2 = dataFlavor.getSubType();
            String string3 = string + "/" + string2;
            Class clazz = dataFlavor.getRepresentationClass();
            String string4 = dataFlavor2.getPrimaryType();
            String string5 = dataFlavor2.getSubType();
            String string6 = string4 + "/" + string5;
            Class clazz2 = dataFlavor2.getRepresentationClass();
            if (dataFlavor.isFlavorTextType() && dataFlavor2.isFlavorTextType()) {
                n2 = IndexedComparator.compareIndices(textTypes, string3, string6, UNKNOWN_OBJECT_LOSES);
                if (n2 != 0) {
                    return n2;
                }
                if (DataTransferer.doesSubtypeSupportCharset(dataFlavor)) {
                    n2 = IndexedComparator.compareIndices(decodedTextRepresentations, clazz, clazz2, UNKNOWN_OBJECT_LOSES);
                    if (n2 != 0) {
                        return n2;
                    }
                    n2 = this.charsetComparator.compareCharsets(DataTransferer.getTextCharset(dataFlavor), DataTransferer.getTextCharset(dataFlavor2));
                    if (n2 != 0) {
                        return n2;
                    }
                }
                if ((n2 = IndexedComparator.compareIndices(encodedTextRepresentations, clazz, clazz2, UNKNOWN_OBJECT_LOSES)) != 0) {
                    return n2;
                }
            } else {
                n2 = IndexedComparator.compareIndices(primaryTypes, string, string4, UNKNOWN_OBJECT_LOSES);
                if (n2 != 0) {
                    return n2;
                }
                n2 = IndexedComparator.compareIndices(exactTypes, string3, string6, UNKNOWN_OBJECT_WINS);
                if (n2 != 0) {
                    return n2;
                }
                n2 = IndexedComparator.compareIndices(nonTextRepresentations, clazz, clazz2, UNKNOWN_OBJECT_LOSES);
                if (n2 != 0) {
                    return n2;
                }
            }
            return IndexedComparator.compareLongs(this.flavorToFormatMap, dataFlavor, dataFlavor2, UNKNOWN_OBJECT_LOSES_L);
        }

        static {
            UNKNOWN_OBJECT_LOSES = new Integer(Integer.MIN_VALUE);
            UNKNOWN_OBJECT_WINS = new Integer(Integer.MAX_VALUE);
            UNKNOWN_OBJECT_LOSES_L = new Long(Long.MIN_VALUE);
            UNKNOWN_OBJECT_WINS_L = new Long(Long.MAX_VALUE);
            HashMap hashMap = new HashMap(4, 1.0f);
            hashMap.put("application/x-java-file-list", new Integer(0));
            hashMap.put("application/x-java-serialized-object", new Integer(1));
            hashMap.put("application/x-java-jvm-local-objectref", new Integer(2));
            hashMap.put("application/x-java-remote-object", new Integer(3));
            exactTypes = Collections.unmodifiableMap(hashMap);
            hashMap = new HashMap(1, 1.0f);
            hashMap.put("application", new Integer(0));
            primaryTypes = Collections.unmodifiableMap(hashMap);
            hashMap = new HashMap(3, 1.0f);
            hashMap.put(class$java$io$InputStream == null ? (class$java$io$InputStream = DataTransferer.class$("java.io.InputStream")) : class$java$io$InputStream, new Integer(0));
            hashMap.put(class$java$io$Serializable == null ? (class$java$io$Serializable = DataTransferer.class$("java.io.Serializable")) : class$java$io$Serializable, new Integer(1));
            hashMap.put(class$java$rmi$Remote == null ? (class$java$rmi$Remote = DataTransferer.class$("java.rmi.Remote")) : class$java$rmi$Remote, new Integer(2));
            nonTextRepresentations = Collections.unmodifiableMap(hashMap);
            hashMap = new HashMap(16, 1.0f);
            hashMap.put("text/plain", new Integer(0));
            hashMap.put("application/x-java-serialized-object", new Integer(1));
            hashMap.put("text/calendar", new Integer(2));
            hashMap.put("text/css", new Integer(3));
            hashMap.put("text/directory", new Integer(4));
            hashMap.put("text/parityfec", new Integer(5));
            hashMap.put("text/rfc822-headers", new Integer(6));
            hashMap.put("text/t140", new Integer(7));
            hashMap.put("text/tab-separated-values", new Integer(8));
            hashMap.put("text/uri-list", new Integer(9));
            hashMap.put("text/richtext", new Integer(10));
            hashMap.put("text/enriched", new Integer(11));
            hashMap.put("text/rtf", new Integer(12));
            hashMap.put("text/html", new Integer(13));
            hashMap.put("text/xml", new Integer(14));
            hashMap.put("text/sgml", new Integer(15));
            textTypes = Collections.unmodifiableMap(hashMap);
            hashMap = new HashMap(4, 1.0f);
            hashMap.put(charArrayClass, new Integer(0));
            hashMap.put(class$java$nio$CharBuffer == null ? (class$java$nio$CharBuffer = DataTransferer.class$("java.nio.CharBuffer")) : class$java$nio$CharBuffer, new Integer(1));
            hashMap.put(class$java$lang$String == null ? (class$java$lang$String = DataTransferer.class$("java.lang.String")) : class$java$lang$String, new Integer(2));
            hashMap.put(class$java$io$Reader == null ? (class$java$io$Reader = DataTransferer.class$("java.io.Reader")) : class$java$io$Reader, new Integer(3));
            decodedTextRepresentations = Collections.unmodifiableMap(hashMap);
            hashMap = new HashMap(3, 1.0f);
            hashMap.put(byteArrayClass, new Integer(0));
            hashMap.put(class$java$nio$ByteBuffer == null ? (class$java$nio$ByteBuffer = DataTransferer.class$("java.nio.ByteBuffer")) : class$java$nio$ByteBuffer, new Integer(1));
            hashMap.put(class$java$io$InputStream == null ? (class$java$io$InputStream = DataTransferer.class$("java.io.InputStream")) : class$java$io$InputStream, new Integer(2));
            encodedTextRepresentations = Collections.unmodifiableMap(hashMap);
        }
    }

    public static class CharsetComparator
    extends IndexedComparator {
        private static final Map charsets;
        private static String defaultEncoding;
        private static final Integer DEFAULT_CHARSET_INDEX;
        private static final Integer OTHER_CHARSET_INDEX;
        private static final Integer WORST_CHARSET_INDEX;
        private static final Integer UNSUPPORTED_CHARSET_INDEX;
        private static final String UNSUPPORTED_CHARSET = "UNSUPPORTED";

        public CharsetComparator() {
            this(true);
        }

        public CharsetComparator(boolean bl2) {
            super(bl2);
        }

        public int compare(Object object, Object object2) {
            String string = null;
            String string2 = null;
            if (this.order) {
                string = (String)object;
                string2 = (String)object2;
            } else {
                string = (String)object2;
                string2 = (String)object;
            }
            return this.compareCharsets(string, string2);
        }

        protected int compareCharsets(String string, String string2) {
            int n2 = IndexedComparator.compareIndices(charsets, string = CharsetComparator.getEncoding(string), string2 = CharsetComparator.getEncoding(string2), OTHER_CHARSET_INDEX);
            if (n2 == 0) {
                return string2.compareTo(string);
            }
            return n2;
        }

        protected static String getEncoding(String string) {
            if (string == null) {
                return null;
            }
            if (!DataTransferer.isEncodingSupported(string)) {
                return UNSUPPORTED_CHARSET;
            }
            String string2 = DataTransferer.canonicalName(string);
            return charsets.containsKey(string2) ? string2 : string;
        }

        static {
            DEFAULT_CHARSET_INDEX = new Integer(2);
            OTHER_CHARSET_INDEX = new Integer(1);
            WORST_CHARSET_INDEX = new Integer(0);
            UNSUPPORTED_CHARSET_INDEX = new Integer(Integer.MIN_VALUE);
            HashMap hashMap = new HashMap(8, 1.0f);
            hashMap.put("Unicode", new Integer(3));
            hashMap.put("UnicodeLittleUnmarked", new Integer(4));
            hashMap.put("UnicodeBigUnmarked", new Integer(5));
            hashMap.put("UTF8", new Integer(6));
            hashMap.put("UTF16", new Integer(7));
            hashMap.put("ASCII", WORST_CHARSET_INDEX);
            String string = DataTransferer.canonicalName(DataTransferer.getDefaultTextCharset());
            if (hashMap.get(defaultEncoding) == null) {
                hashMap.put(defaultEncoding, DEFAULT_CHARSET_INDEX);
            }
            hashMap.put(UNSUPPORTED_CHARSET, UNSUPPORTED_CHARSET_INDEX);
            charsets = Collections.unmodifiableMap(hashMap);
        }
    }

    public static abstract class IndexedComparator
    implements Comparator {
        public static final boolean SELECT_BEST = true;
        public static final boolean SELECT_WORST = false;
        protected final boolean order;

        public IndexedComparator() {
            this(true);
        }

        public IndexedComparator(boolean bl2) {
            this.order = bl2;
        }

        protected static int compareIndices(Map map, Object object, Object object2, Integer n2) {
            Integer n3 = (Integer)map.get(object);
            Integer n4 = (Integer)map.get(object2);
            if (n3 == null) {
                n3 = n2;
            }
            if (n4 == null) {
                n4 = n2;
            }
            return n3.compareTo(n4);
        }

        protected static int compareLongs(Map map, Object object, Object object2, Long l2) {
            Long l3 = (Long)map.get(object);
            Long l4 = (Long)map.get(object2);
            if (l3 == null) {
                l3 = l2;
            }
            if (l4 == null) {
                l4 = l2;
            }
            return l3.compareTo(l4);
        }
    }

    public class ReencodingInputStream
    extends InputStream {
        protected BufferedReader wrapped;
        protected CharToByteConverter converter;
        protected final char[] in = new char[1];
        protected byte[] out;
        protected CharsetEncoder encoder;
        protected CharBuffer inBuf;
        protected ByteBuffer outBuf;
        protected char[] eoln;
        protected int numTerminators;
        protected boolean eos;
        protected int index;
        protected int limit;

        public ReencodingInputStream(InputStream inputStream, long l2, String string, Transferable transferable) throws IOException {
            Integer n2;
            Long l3 = new Long(l2);
            String string2 = null;
            if (DataTransferer.this.isLocaleDependentTextFormat(l2) && transferable != null && transferable.isDataFlavorSupported(javaTextEncodingFlavor)) {
                try {
                    string2 = new String((byte[])transferable.getTransferData(javaTextEncodingFlavor), "UTF-8");
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {}
            } else {
                string2 = (String)nativeCharsets.get(l3);
            }
            if (string2 == null) {
                string2 = DataTransferer.getDefaultTextCharset();
            }
            this.wrapped = new BufferedReader(new InputStreamReader(inputStream, string2));
            try {
                this.converter = CharToByteConverter.getConverter(string);
                this.out = new byte[this.converter.getMaxBytesPerChar()];
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    this.encoder = Charset.forName(string).newEncoder();
                    this.out = new byte[(int)((double)this.encoder.maxBytesPerChar() + 0.5)];
                    this.inBuf = CharBuffer.wrap(this.in);
                    this.outBuf = ByteBuffer.wrap(this.out);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    throw unsupportedEncodingException;
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    throw unsupportedEncodingException;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    throw unsupportedEncodingException;
                }
            }
            String string3 = (String)nativeEOLNs.get(l3);
            if (string3 != null) {
                this.eoln = string3.toCharArray();
            }
            if ((n2 = (Integer)nativeTerminators.get(l3)) != null) {
                this.numTerminators = n2;
            }
        }

        public int read() throws IOException {
            if (this.eos) {
                return -1;
            }
            if (this.index >= this.limit) {
                int n2 = this.wrapped.read();
                if (n2 == -1) {
                    this.eos = true;
                    return -1;
                }
                if (this.numTerminators > 0 && n2 == 0) {
                    this.eos = true;
                    return -1;
                }
                if (this.eoln != null && this.matchCharArray(this.eoln, n2)) {
                    n2 = 10;
                }
                this.in[0] = (char)n2;
                if (this.converter != null) {
                    this.limit = this.converter.convert(this.in, 0, 1, this.out, 0, this.out.length);
                } else {
                    this.inBuf.rewind();
                    this.outBuf.rewind();
                    this.encoder.encode(this.inBuf, this.outBuf, false);
                    this.limit = this.outBuf.limit();
                }
                this.index = 0;
                return this.read();
            }
            return this.out[this.index++] & 0xFF;
        }

        public int available() throws IOException {
            return this.eos ? 0 : this.limit - this.index;
        }

        public void close() throws IOException {
            this.wrapped.close();
        }

        private boolean matchCharArray(char[] cArray, int n2) throws IOException {
            this.wrapped.mark(cArray.length);
            int n3 = 0;
            if ((char)n2 == cArray[0]) {
                n3 = 1;
                while (n3 < cArray.length) {
                    n2 = this.wrapped.read();
                    if (n2 == -1 || (char)n2 != cArray[n3]) break;
                    ++n3;
                }
            }
            if (n3 == cArray.length) {
                return true;
            }
            this.wrapped.reset();
            return false;
        }
    }
}

