/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.compiler;

import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;

public class OpMap {
    protected String m_currentPattern;
    static final int MAXTOKENQUEUESIZE = 500;
    public Object[] m_tokenQueue = new Object[500];
    public int m_tokenQueueSize = 0;
    public int[] m_opMap = null;
    public static final int MAPINDEX_LENGTH = 1;

    public String toString() {
        return this.m_currentPattern;
    }

    public String getPatternString() {
        return this.m_currentPattern;
    }

    public Object[] getTokenQueue() {
        return this.m_tokenQueue;
    }

    public Object getToken(int n2) {
        return this.m_tokenQueue[n2];
    }

    public int getTokenQueueSize() {
        return this.m_tokenQueueSize;
    }

    public int[] getOpMap() {
        return this.m_opMap;
    }

    void shrink() {
        int[] nArray = this.m_opMap;
        int n2 = this.m_opMap[1];
        this.m_opMap = new int[n2 + 4];
        int n3 = 0;
        while (n3 < n2) {
            this.m_opMap[n3] = nArray[n3];
            ++n3;
        }
        this.m_opMap[n3] = 0;
        this.m_opMap[n3 + 1] = 0;
        this.m_opMap[n3 + 2] = 0;
        Object[] objectArray = this.m_tokenQueue;
        n2 = this.m_tokenQueueSize;
        this.m_tokenQueue = new Object[n2 + 4];
        n3 = 0;
        while (n3 < n2) {
            this.m_tokenQueue[n3] = objectArray[n3];
            ++n3;
        }
        this.m_tokenQueue[n3] = null;
        this.m_tokenQueue[n3 + 1] = null;
        this.m_tokenQueue[n3 + 2] = null;
    }

    public int getOp(int n2) {
        return this.m_opMap[n2];
    }

    public int getNextOpPos(int n2) {
        return n2 + this.m_opMap[n2 + 1];
    }

    public int getNextStepPos(int n2) {
        int n3 = this.getOp(n2);
        if (n3 >= 37 && n3 <= 53) {
            return this.getNextOpPos(n2);
        }
        if (n3 >= 22 && n3 <= 25) {
            int n4 = this.getNextOpPos(n2);
            while (29 == this.getOp(n4)) {
                n4 = this.getNextOpPos(n4);
            }
            n3 = this.getOp(n4);
            if (n3 < 37 || n3 > 53) {
                return -1;
            }
            return n4;
        }
        throw new RuntimeException("Programmer's assertion in getNextStepPos: unknown stepType: " + n3);
    }

    public static int getNextOpPos(int[] nArray, int n2) {
        return n2 + nArray[n2 + 1];
    }

    public int getFirstPredicateOpPos(int n2) throws TransformerException {
        int n3 = this.m_opMap[n2];
        if (n3 >= 37 && n3 <= 53) {
            return n2 + this.m_opMap[n2 + 2];
        }
        if (n3 >= 22 && n3 <= 25) {
            return n2 + this.m_opMap[n2 + 1];
        }
        if (-2 == n3) {
            return -2;
        }
        this.error(24, new Object[]{String.valueOf(n3)});
        return -1;
    }

    public void error(int n2, Object[] objectArray) throws TransformerException {
        String string = XSLMessages.createXPATHMessage(n2, objectArray);
        throw new TransformerException(string);
    }

    public static int getFirstChildPos(int n2) {
        return n2 + 2;
    }

    public int getArgLength(int n2) {
        return this.m_opMap[n2 + 1];
    }

    public int getArgLengthOfStep(int n2) {
        return this.m_opMap[n2 + 1 + 1] - 3;
    }

    public static int getFirstChildPosOfStep(int n2) {
        return n2 + 3;
    }

    public int getStepTestType(int n2) {
        return this.m_opMap[n2 + 3];
    }

    public String getStepNS(int n2) {
        int n3 = this.getArgLengthOfStep(n2);
        if (n3 == 3) {
            int n4 = this.m_opMap[n2 + 4];
            if (n4 >= 0) {
                return (String)this.m_tokenQueue[n4];
            }
            if (-3 == n4) {
                return "*";
            }
            return null;
        }
        return null;
    }

    public String getStepLocalName(int n2) {
        int n3;
        int n4 = this.getArgLengthOfStep(n2);
        switch (n4) {
            case 0: {
                n3 = -2;
                break;
            }
            case 1: {
                n3 = -3;
                break;
            }
            case 2: {
                n3 = this.m_opMap[n2 + 4];
                break;
            }
            case 3: {
                n3 = this.m_opMap[n2 + 5];
                break;
            }
            default: {
                n3 = -2;
            }
        }
        if (n3 >= 0) {
            return this.m_tokenQueue[n3].toString();
        }
        if (-3 == n3) {
            return "*";
        }
        return null;
    }
}

