/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;

public abstract class PredicatedNodeTest
extends NodeTest
implements SubContextList {
    protected transient boolean m_foundLast = false;
    protected LocPathIterator m_lpi;
    transient int m_predicateIndex = -1;
    private Expression[] m_predicates;
    protected transient int[] m_proximityPositions;
    static final boolean DEBUG_PREDICATECOUNTING = false;

    PredicatedNodeTest(LocPathIterator locPathIterator) {
        this.m_lpi = locPathIterator;
    }

    PredicatedNodeTest() {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, TransformerException {
        try {
            objectInputStream.defaultReadObject();
            this.m_predicateIndex = -1;
            this.resetProximityPositions();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TransformerException(classNotFoundException);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PredicatedNodeTest predicatedNodeTest = (PredicatedNodeTest)super.clone();
        if (null != this.m_proximityPositions && this.m_proximityPositions == predicatedNodeTest.m_proximityPositions) {
            predicatedNodeTest.m_proximityPositions = new int[this.m_proximityPositions.length];
            System.arraycopy(this.m_proximityPositions, 0, predicatedNodeTest.m_proximityPositions, 0, this.m_proximityPositions.length);
        }
        if (predicatedNodeTest.m_lpi == this) {
            predicatedNodeTest.m_lpi = (LocPathIterator)predicatedNodeTest;
        }
        return predicatedNodeTest;
    }

    public int getPredicateCount() {
        return null == this.m_predicates ? 0 : this.m_predicates.length;
    }

    public void setPredicateCount(int n2) {
        if (n2 > 0) {
            Expression[] expressionArray = new Expression[n2];
            int n3 = 0;
            while (n3 < n2) {
                expressionArray[n3] = this.m_predicates[n3];
                ++n3;
            }
            this.m_predicates = expressionArray;
        } else {
            this.m_predicates = null;
        }
    }

    protected void initPredicateInfo(Compiler compiler, int n2) throws TransformerException {
        int n3 = compiler.getFirstPredicateOpPos(n2);
        if (n3 > 0) {
            this.m_predicates = compiler.getCompiledPredicates(n3);
        }
    }

    Expression getPredicate(int n2) {
        return this.m_predicates[n2];
    }

    public int getProximityPosition() {
        return this.getProximityPosition(this.m_predicateIndex);
    }

    public int getProximityPosition(XPathContext xPathContext) {
        return this.getProximityPosition();
    }

    public abstract int getLastPos(XPathContext var1);

    protected int getProximityPosition(int n2) {
        return n2 >= 0 ? this.m_proximityPositions[n2] : 0;
    }

    public void resetProximityPositions() {
        int n2 = this.getPredicateCount();
        if (n2 > 0) {
            if (null == this.m_proximityPositions) {
                this.m_proximityPositions = new int[n2];
            }
            int n3 = 0;
            while (n3 < n2) {
                try {
                    this.initProximityPosition(n3);
                }
                catch (Exception exception) {
                    throw new WrappedRuntimeException(exception);
                }
                ++n3;
            }
        }
    }

    public void initProximityPosition(int n2) throws TransformerException {
        this.m_proximityPositions[n2] = 0;
    }

    protected void countProximityPosition(int n2) {
        if (n2 < this.m_proximityPositions.length) {
            int n3 = n2;
            this.m_proximityPositions[n3] = this.m_proximityPositions[n3] + 1;
        }
    }

    public boolean isReverseAxes() {
        return false;
    }

    public int getPredicateIndex() {
        return this.m_predicateIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean executePredicates(int n2, XPathContext xPathContext) throws TransformerException {
        block10: {
            int n3;
            int n4 = this.getPredicateCount();
            if (n4 == 0) {
                return true;
            }
            PrefixResolver prefixResolver = xPathContext.getNamespaceContext();
            try {
                this.m_predicateIndex = 0;
                xPathContext.pushSubContextList(this);
                xPathContext.pushNamespaceContext(this.m_lpi.getPrefixResolver());
                xPathContext.pushCurrentNode(n2);
                int n5 = 0;
                while (true) {
                    if (n5 >= n4) {
                        break block10;
                    }
                    XObject xObject = this.m_predicates[n5].execute(xPathContext);
                    if (2 == xObject.getType()) {
                        n3 = this.getProximityPosition(this.m_predicateIndex);
                        if (n3 != (int)xObject.num()) {
                            boolean bl2 = false;
                            Object var10_9 = null;
                            xPathContext.popCurrentNode();
                            xPathContext.popNamespaceContext();
                            xPathContext.popSubContextList();
                            this.m_predicateIndex = -1;
                            return bl2;
                        }
                        if (this.m_predicates[n5].isStableNumber()) {
                            this.m_foundLast = true;
                        }
                    } else if (!xObject.bool()) {
                        n3 = 0;
                        break;
                    }
                    this.countProximityPosition(++this.m_predicateIndex);
                    ++n5;
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                xPathContext.popCurrentNode();
                xPathContext.popNamespaceContext();
                xPathContext.popSubContextList();
                this.m_predicateIndex = -1;
                throw throwable;
            }
            Object var10_10 = null;
            xPathContext.popCurrentNode();
            xPathContext.popNamespaceContext();
            xPathContext.popSubContextList();
            this.m_predicateIndex = -1;
            return n3 != 0;
        }
        Object var10_11 = null;
        xPathContext.popCurrentNode();
        xPathContext.popNamespaceContext();
        xPathContext.popSubContextList();
        this.m_predicateIndex = -1;
        return true;
    }

    public void fixupVariables(Vector vector, int n2) {
        super.fixupVariables(vector, n2);
        int n3 = this.getPredicateCount();
        int n4 = 0;
        while (n4 < n3) {
            this.m_predicates[n4].fixupVariables(vector, n2);
            ++n4;
        }
    }

    protected String nodeToString(int n2) {
        if (-1 != n2) {
            DTM dTM = this.m_lpi.getXPathContext().getDTM(n2);
            return dTM.getNodeName(n2) + "{" + (n2 + 1) + "}";
        }
        return "null";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short acceptNode(int n2) {
        XPathContext xPathContext;
        block7: {
            short s2;
            xPathContext = this.m_lpi.getXPathContext();
            try {
                try {
                    xPathContext.pushCurrentNode(n2);
                    XObject xObject = this.execute(xPathContext, n2);
                    if (xObject == NodeTest.SCORE_NONE) break block7;
                    if (this.getPredicateCount() > 0) {
                        this.countProximityPosition(0);
                        if (!this.executePredicates(n2, xPathContext)) {
                            short s3 = 3;
                            Object var6_7 = null;
                            xPathContext.popCurrentNode();
                            return s3;
                        }
                    }
                    s2 = 1;
                }
                catch (TransformerException transformerException) {
                    throw new RuntimeException(transformerException.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                xPathContext.popCurrentNode();
                throw throwable;
            }
            Object var6_8 = null;
            xPathContext.popCurrentNode();
            return s2;
        }
        Object var6_9 = null;
        xPathContext.popCurrentNode();
        return 3;
    }

    public LocPathIterator getLocPathIterator() {
        return this.m_lpi;
    }

    public void setLocPathIterator(LocPathIterator locPathIterator) {
        this.m_lpi = locPathIterator;
    }

    public boolean canTraverseOutsideSubtree() {
        int n2 = this.getPredicateCount();
        int n3 = 0;
        while (n3 < n2) {
            if (this.getPredicate(n3).canTraverseOutsideSubtree()) {
                return true;
            }
            ++n3;
        }
        return false;
    }
}

