/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import sun.security.pkcs.ParsingException;
import sun.security.util.Debug;
import sun.security.util.ManifestDigester;
import sun.security.util.ManifestEntryVerifier;
import sun.security.util.SignatureFileVerifier;

class JarVerifier {
    static final Debug debug = Debug.getInstance("jar");
    private Hashtable verifiedCerts;
    private Hashtable sigFileCerts;
    private Hashtable sigFileData;
    private ArrayList pendingBlocks;
    private ArrayList certCache;
    private boolean parsingBlockOrSF = false;
    private boolean parsingMeta = true;
    private boolean anyToVerify = true;
    private Manifest manifest;
    private ByteArrayOutputStream baos;
    private ManifestDigester manDig;
    byte[] manifestRawBytes = null;

    public JarVerifier(Manifest manifest, byte[] byArray) {
        this.manifestRawBytes = byArray;
        this.sigFileCerts = new Hashtable();
        this.verifiedCerts = new Hashtable();
        this.sigFileData = new Hashtable(11);
        this.pendingBlocks = new ArrayList();
        this.baos = new ByteArrayOutputStream();
        this.manifest = manifest;
    }

    public void beginEntry(JarEntry jarEntry, ManifestEntryVerifier manifestEntryVerifier) throws IOException {
        String string;
        if (jarEntry == null) {
            return;
        }
        if (debug != null) {
            debug.println("beginEntry " + jarEntry.getName());
        }
        String string2 = jarEntry.getName();
        if (this.parsingMeta && ((string = string2.toUpperCase()).startsWith("META-INF/") || string.startsWith("/META-INF/"))) {
            if (jarEntry.isDirectory()) {
                manifestEntryVerifier.setEntry(null, jarEntry);
                return;
            }
            if (string.endsWith(".DSA") || string.endsWith(".RSA") || string.endsWith(".SF")) {
                this.parsingBlockOrSF = true;
                this.baos.reset();
                manifestEntryVerifier.setEntry(null, jarEntry);
            }
            return;
        }
        if (this.parsingMeta) {
            this.doneWithMeta();
        }
        if (jarEntry.isDirectory()) {
            manifestEntryVerifier.setEntry(null, jarEntry);
            return;
        }
        if (string2.startsWith("./")) {
            string2 = string2.substring(2);
        }
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        if (this.sigFileCerts.get(string2) != null) {
            manifestEntryVerifier.setEntry(string2, jarEntry);
            return;
        }
        manifestEntryVerifier.setEntry(null, jarEntry);
    }

    public void update(int n2, ManifestEntryVerifier manifestEntryVerifier) throws IOException {
        if (n2 != -1) {
            if (this.parsingBlockOrSF) {
                this.baos.write(n2);
            } else {
                manifestEntryVerifier.update((byte)n2);
            }
        } else {
            this.processEntry(manifestEntryVerifier);
        }
    }

    public void update(int n2, byte[] byArray, int n3, int n4, ManifestEntryVerifier manifestEntryVerifier) throws IOException {
        if (n2 != -1) {
            if (this.parsingBlockOrSF) {
                this.baos.write(byArray, n3, n2);
            } else {
                manifestEntryVerifier.update(byArray, n3, n2);
            }
        } else {
            this.processEntry(manifestEntryVerifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEntry(ManifestEntryVerifier manifestEntryVerifier) throws IOException {
        block24: {
            if (!this.parsingBlockOrSF) {
                JarEntry jarEntry = manifestEntryVerifier.getEntry();
                if (jarEntry != null && jarEntry.certs == null) {
                    jarEntry.certs = manifestEntryVerifier.verify(this.verifiedCerts, this.sigFileCerts);
                }
            } else {
                try {
                    Object object;
                    String string;
                    this.parsingBlockOrSF = false;
                    if (debug != null) {
                        debug.println("processEntry: processing block");
                    }
                    if ((string = manifestEntryVerifier.getEntry().getName().toUpperCase()).endsWith(".SF")) {
                        String string2 = string.substring(0, string.length() - 3);
                        byte[] byArray = this.baos.toByteArray();
                        this.sigFileData.put(string2, byArray);
                        Iterator iterator = this.pendingBlocks.iterator();
                        while (iterator.hasNext()) {
                            SignatureFileVerifier signatureFileVerifier = (SignatureFileVerifier)iterator.next();
                            if (!signatureFileVerifier.needSignatureFile(string2)) continue;
                            if (debug != null) {
                                debug.println("processEntry: processing pending block");
                            }
                            signatureFileVerifier.setSignatureFile(byArray);
                            signatureFileVerifier.process(this.sigFileCerts);
                        }
                        return;
                    }
                    String string3 = string.substring(0, string.lastIndexOf("."));
                    if (this.certCache == null) {
                        this.certCache = new ArrayList();
                    }
                    if (this.manDig == null) {
                        object = this.manifestRawBytes;
                        synchronized (object) {
                            if (this.manDig == null) {
                                this.manDig = new ManifestDigester(this.manifestRawBytes);
                                this.manifestRawBytes = null;
                            }
                        }
                    }
                    if (((SignatureFileVerifier)(object = (Object)new SignatureFileVerifier(this.certCache, this.manDig, string, this.baos.toByteArray()))).needSignatureFileBytes()) {
                        byte[] byArray = (byte[])this.sigFileData.get(string3);
                        if (byArray == null) {
                            if (debug != null) {
                                debug.println("adding pending block");
                            }
                            this.pendingBlocks.add(object);
                            return;
                        }
                        ((SignatureFileVerifier)object).setSignatureFile(byArray);
                    }
                    ((SignatureFileVerifier)object).process(this.sigFileCerts);
                }
                catch (ParsingException parsingException) {
                    if (debug != null) {
                        debug.println("processEntry caught: " + parsingException);
                    }
                }
                catch (IOException iOException) {
                    if (debug != null) {
                        debug.println("processEntry caught: " + iOException);
                    }
                }
                catch (SignatureException signatureException) {
                    if (debug != null) {
                        debug.println("processEntry caught: " + signatureException);
                    }
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    if (debug == null) break block24;
                    debug.println("processEntry caught: " + noSuchAlgorithmException);
                }
            }
        }
    }

    public Certificate[] getCerts(String string) {
        return (Certificate[])this.verifiedCerts.get(string);
    }

    boolean nothingToVerify() {
        return !this.anyToVerify;
    }

    void doneWithMeta() {
        this.parsingMeta = false;
        this.anyToVerify = !this.sigFileCerts.isEmpty();
        this.baos = null;
        this.sigFileData = null;
        this.pendingBlocks = null;
        this.certCache = null;
        this.manDig = null;
    }

    static class VerifierStream
    extends InputStream {
        private InputStream is;
        private JarVerifier jv;
        private ManifestEntryVerifier mev;
        private long numLeft;

        VerifierStream(Manifest manifest, JarEntry jarEntry, InputStream inputStream, JarVerifier jarVerifier) throws IOException {
            this.is = inputStream;
            this.jv = jarVerifier;
            this.mev = new ManifestEntryVerifier(manifest);
            this.jv.beginEntry(jarEntry, this.mev);
            this.numLeft = jarEntry.getSize();
        }

        public int read() throws IOException {
            if (this.numLeft > 0L) {
                int n2 = this.is.read();
                this.jv.update(n2, this.mev);
                --this.numLeft;
                if (this.numLeft == 0L) {
                    this.jv.update(-1, this.mev);
                }
                return n2;
            }
            return -1;
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            if (this.numLeft > 0L && this.numLeft < (long)n3) {
                n3 = (int)this.numLeft;
            }
            if (this.numLeft > 0L) {
                int n4 = this.is.read(byArray, n2, n3);
                this.jv.update(n4, byArray, n2, n3, this.mev);
                this.numLeft -= (long)n4;
                if (this.numLeft == 0L) {
                    this.jv.update(-1, byArray, n2, n3, this.mev);
                }
                return n4;
            }
            return -1;
        }

        public void close() throws IOException {
            if (this.is != null) {
                this.is.close();
            }
            this.is = null;
            this.mev = null;
            this.jv = null;
        }

        public int available() throws IOException {
            return this.is.available();
        }
    }
}

