/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.PropertyPermission;

final class PropertyPermissionCollection
extends PermissionCollection
implements Serializable {
    private Hashtable permissions = new Hashtable(32);
    private boolean all_allowed = false;

    public void add(Permission permission) {
        if (!(permission instanceof PropertyPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        PropertyPermission propertyPermission = (PropertyPermission)permission;
        PropertyPermission propertyPermission2 = (PropertyPermission)this.permissions.get(propertyPermission.getName());
        if (propertyPermission2 != null) {
            int n2;
            int n3 = propertyPermission2.getMask();
            if (n3 != (n2 = propertyPermission.getMask())) {
                int n4 = n3 | n2;
                String string = PropertyPermission.getActions(n4);
                this.permissions.put(propertyPermission.getName(), new PropertyPermission(propertyPermission.getName(), string));
            }
        } else {
            this.permissions.put(propertyPermission.getName(), permission);
        }
        if (!this.all_allowed && propertyPermission.getName().equals("*")) {
            this.all_allowed = true;
        }
    }

    public boolean implies(Permission permission) {
        int n2;
        PropertyPermission propertyPermission;
        if (!(permission instanceof PropertyPermission)) {
            return false;
        }
        PropertyPermission propertyPermission2 = (PropertyPermission)permission;
        int n3 = propertyPermission2.getMask();
        int n4 = 0;
        if (this.all_allowed && (propertyPermission = (PropertyPermission)this.permissions.get("*")) != null && ((n4 |= propertyPermission.getMask()) & n3) == n3) {
            return true;
        }
        String string = propertyPermission2.getName();
        propertyPermission = (PropertyPermission)this.permissions.get(string);
        if (propertyPermission != null && ((n4 |= propertyPermission.getMask()) & n3) == n3) {
            return true;
        }
        int n5 = string.length() - 1;
        while ((n2 = string.lastIndexOf(".", n5)) != -1) {
            propertyPermission = (PropertyPermission)this.permissions.get(string = string.substring(0, n2 + 1) + "*");
            if (propertyPermission != null && ((n4 |= propertyPermission.getMask()) & n3) == n3) {
                return true;
            }
            n5 = n2 - 1;
        }
        return false;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

