/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import sun.nio.cs.ThreadLocalCoders;
import sun.text.Normalizer;

public final class URI
implements Comparable,
Serializable {
    static final long serialVersionUID = -6052424284110960213L;
    private transient String scheme;
    private transient String fragment;
    private transient String authority;
    private transient String userInfo;
    private transient String host;
    private transient int port = -1;
    private transient String path;
    private transient String query;
    private volatile transient String schemeSpecificPart;
    private volatile transient int hash;
    private volatile transient String decodedUserInfo = null;
    private volatile transient String decodedAuthority = null;
    private volatile transient String decodedPath = null;
    private volatile transient String decodedQuery = null;
    private volatile transient String decodedFragment = null;
    private volatile transient String decodedSchemeSpecificPart = null;
    private volatile String string;
    private static final long L_DIGIT;
    private static final long H_DIGIT = 0L;
    private static final long L_UPALPHA = 0L;
    private static final long H_UPALPHA;
    private static final long L_LOWALPHA = 0L;
    private static final long H_LOWALPHA;
    private static final long L_ALPHA = 0L;
    private static final long H_ALPHA;
    private static final long L_ALPHANUM;
    private static final long H_ALPHANUM;
    private static final long L_HEX;
    private static final long H_HEX;
    private static final long L_MARK;
    private static final long H_MARK;
    private static final long L_UNRESERVED;
    private static final long H_UNRESERVED;
    private static final long L_RESERVED;
    private static final long H_RESERVED;
    private static final long L_ESCAPED = 1L;
    private static final long H_ESCAPED = 0L;
    private static final long L_URIC;
    private static final long H_URIC;
    private static final long L_PCHAR;
    private static final long H_PCHAR;
    private static final long L_PATH;
    private static final long H_PATH;
    private static final long L_DASH;
    private static final long H_DASH;
    private static final long L_DOT;
    private static final long H_DOT;
    private static final long L_USERINFO;
    private static final long H_USERINFO;
    private static final long L_REG_NAME;
    private static final long H_REG_NAME;
    private static final long L_SERVER;
    private static final long H_SERVER;
    private static final long L_SCHEME;
    private static final long H_SCHEME;
    private static final long L_URIC_NO_SLASH;
    private static final long H_URIC_NO_SLASH;
    private static final char[] hexDigits;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$net$URI;

    private URI() {
    }

    public URI(String string) throws URISyntaxException {
        new Parser(string).parse(false);
    }

    public URI(String string, String string2, String string3, int n2, String string4, String string5, String string6) throws URISyntaxException {
        String string7 = this.toString(string, null, null, string2, string3, n2, string4, string5, string6);
        URI.checkPath(string7, string, string4);
        new Parser(string7).parse(true);
    }

    public URI(String string, String string2, String string3, String string4, String string5) throws URISyntaxException {
        String string6 = this.toString(string, null, string2, null, null, -1, string3, string4, string5);
        URI.checkPath(string6, string, string3);
        new Parser(string6).parse(false);
    }

    public URI(String string, String string2, String string3, String string4) throws URISyntaxException {
        this(string, null, string2, -1, string3, null, string4);
    }

    public URI(String string, String string2, String string3) throws URISyntaxException {
        new Parser(this.toString(string, string2, null, null, null, -1, null, null, string3)).parse(false);
    }

    public static URI create(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            illegalArgumentException.initCause(uRISyntaxException);
            throw illegalArgumentException;
        }
    }

    public URI parseServerAuthority() throws URISyntaxException {
        if (this.host != null || this.authority == null) {
            return this;
        }
        this.defineString();
        new Parser(this.string).parse(true);
        return this;
    }

    public URI normalize() {
        return URI.normalize(this);
    }

    public URI resolve(URI uRI) {
        return URI.resolve(this, uRI);
    }

    public URI resolve(String string) {
        return this.resolve(URI.create(string));
    }

    public URI relativize(URI uRI) {
        return URI.relativize(this, uRI);
    }

    public URL toURL() throws MalformedURLException {
        if (!this.isAbsolute()) {
            throw new IllegalArgumentException("URI is not absolute");
        }
        return new URL(this.scheme, this.isOpaque() ? this.getRawSchemeSpecificPart() : null, this.authority, this.userInfo, this.host, this.port, this.path, this.query, this.fragment, null);
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isAbsolute() {
        return this.scheme != null;
    }

    public boolean isOpaque() {
        return this.path == null;
    }

    public String getRawSchemeSpecificPart() {
        this.defineSchemeSpecificPart();
        return this.schemeSpecificPart;
    }

    public String getSchemeSpecificPart() {
        if (this.decodedSchemeSpecificPart == null) {
            this.decodedSchemeSpecificPart = URI.decode(this.getRawSchemeSpecificPart());
        }
        return this.decodedSchemeSpecificPart;
    }

    public String getRawAuthority() {
        return this.authority;
    }

    public String getAuthority() {
        if (this.decodedAuthority == null) {
            this.decodedAuthority = URI.decode(this.authority);
        }
        return this.decodedAuthority;
    }

    public String getRawUserInfo() {
        return this.userInfo;
    }

    public String getUserInfo() {
        if (this.decodedUserInfo == null && this.userInfo != null) {
            this.decodedUserInfo = URI.decode(this.userInfo);
        }
        return this.decodedUserInfo;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getRawPath() {
        return this.path;
    }

    public String getPath() {
        if (this.decodedPath == null && this.path != null) {
            this.decodedPath = URI.decode(this.path);
        }
        return this.decodedPath;
    }

    public String getRawQuery() {
        return this.query;
    }

    public String getQuery() {
        if (this.decodedQuery == null && this.query != null) {
            this.decodedQuery = URI.decode(this.query);
        }
        return this.decodedQuery;
    }

    public String getRawFragment() {
        return this.fragment;
    }

    public String getFragment() {
        if (this.decodedFragment == null && this.fragment != null) {
            this.decodedFragment = URI.decode(this.fragment);
        }
        return this.decodedFragment;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof URI)) {
            return false;
        }
        URI uRI = (URI)object;
        if (this.isOpaque() != uRI.isOpaque()) {
            return false;
        }
        if (!URI.equalIgnoringCase(this.scheme, uRI.scheme)) {
            return false;
        }
        if (!URI.equal(this.fragment, uRI.fragment)) {
            return false;
        }
        if (this.isOpaque()) {
            return URI.equal(this.schemeSpecificPart, uRI.schemeSpecificPart);
        }
        if (!URI.equal(this.path, uRI.path)) {
            return false;
        }
        if (!URI.equal(this.query, uRI.query)) {
            return false;
        }
        if (this.authority == uRI.authority) {
            return true;
        }
        if (this.host != null) {
            if (!URI.equal(this.userInfo, uRI.userInfo)) {
                return false;
            }
            if (!URI.equalIgnoringCase(this.host, uRI.host)) {
                return false;
            }
            if (this.port != uRI.port) {
                return false;
            }
        } else if (this.authority != null ? !URI.equal(this.authority, uRI.authority) : this.authority != uRI.authority) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int n2 = URI.hashIgnoringCase(0, this.scheme);
        n2 = URI.hash(n2, this.fragment);
        if (this.isOpaque()) {
            n2 = URI.hash(n2, this.schemeSpecificPart);
        } else {
            n2 = URI.hash(n2, this.path);
            n2 = URI.hash(n2, this.query);
            if (this.host != null) {
                n2 = URI.hash(n2, this.userInfo);
                n2 = URI.hashIgnoringCase(n2, this.host);
                n2 += 1949 * this.port;
            } else {
                n2 = URI.hash(n2, this.authority);
            }
        }
        this.hash = n2;
        return n2;
    }

    public int compareTo(Object object) {
        URI uRI = (URI)object;
        int n2 = URI.compareIgnoringCase(this.scheme, uRI.scheme);
        if (n2 != 0) {
            return n2;
        }
        if (this.isOpaque()) {
            if (uRI.isOpaque()) {
                n2 = URI.compare(this.schemeSpecificPart, uRI.schemeSpecificPart);
                if (n2 != 0) {
                    return n2;
                }
                return URI.compare(this.fragment, uRI.fragment);
            }
            return 1;
        }
        if (uRI.isOpaque()) {
            return -1;
        }
        if (this.host != null && uRI.host != null) {
            n2 = URI.compare(this.userInfo, uRI.userInfo);
            if (n2 != 0) {
                return n2;
            }
            n2 = URI.compareIgnoringCase(this.host, uRI.host);
            if (n2 != 0) {
                return n2;
            }
            n2 = this.port - uRI.port;
            if (n2 != 0) {
                return n2;
            }
        } else {
            n2 = URI.compare(this.authority, uRI.authority);
            if (n2 != 0) {
                return n2;
            }
        }
        if ((n2 = URI.compare(this.path, uRI.path)) != 0) {
            return n2;
        }
        n2 = URI.compare(this.query, uRI.query);
        if (n2 != 0) {
            return n2;
        }
        return URI.compare(this.fragment, uRI.fragment);
    }

    public String toString() {
        this.defineString();
        return this.string;
    }

    public String toASCIIString() {
        this.defineString();
        return URI.encode(this.string);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.defineString();
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.port = -1;
        objectInputStream.defaultReadObject();
        try {
            new Parser(this.string).parse(false);
        }
        catch (URISyntaxException uRISyntaxException) {
            InvalidObjectException invalidObjectException = new InvalidObjectException("Invalid URI");
            invalidObjectException.initCause(uRISyntaxException);
            throw invalidObjectException;
        }
    }

    private static int toLower(char c2) {
        if (c2 >= 'A' && c2 <= 'Z') {
            return c2 + 32;
        }
        return c2;
    }

    private static boolean equal(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string != null && string2 != null) {
            if (string.length() != string2.length()) {
                return false;
            }
            if (string.indexOf(37) < 0) {
                return string.equals(string2);
            }
            int n2 = string.length();
            int n3 = 0;
            while (n3 < n2) {
                char c2 = string.charAt(n3);
                char c3 = string2.charAt(n3);
                if (c2 != '%') {
                    if (c2 != c3) {
                        return false;
                    }
                    ++n3;
                    continue;
                }
                if (URI.toLower(string.charAt(++n3)) != URI.toLower(string2.charAt(n3))) {
                    return false;
                }
                if (URI.toLower(string.charAt(++n3)) != URI.toLower(string2.charAt(n3))) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return false;
    }

    private static boolean equalIgnoringCase(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string != null && string2 != null) {
            int n2 = string.length();
            if (string2.length() != n2) {
                return false;
            }
            int n3 = 0;
            while (n3 < n2) {
                if (URI.toLower(string.charAt(n3)) != URI.toLower(string2.charAt(n3))) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return false;
    }

    private static int hash(int n2, String string) {
        if (string == null) {
            return n2;
        }
        return n2 * 127 + string.hashCode();
    }

    private static int hashIgnoringCase(int n2, String string) {
        if (string == null) {
            return n2;
        }
        int n3 = n2;
        int n4 = string.length();
        int n5 = 0;
        while (n5 < n4) {
            n3 = 31 * n3 + URI.toLower(string.charAt(n5));
            ++n5;
        }
        return n3;
    }

    private static int compare(String string, String string2) {
        if (string == string2) {
            return 0;
        }
        if (string != null) {
            if (string2 != null) {
                return string.compareTo(string2);
            }
            return -1;
        }
        return 1;
    }

    private static int compareIgnoringCase(String string, String string2) {
        if (string == string2) {
            return 0;
        }
        if (string != null) {
            if (string2 != null) {
                int n2;
                int n3 = string.length();
                int n4 = n3 < (n2 = string2.length()) ? n3 : n2;
                int n5 = 0;
                while (n5 < n4) {
                    int n6 = URI.toLower(string.charAt(n5)) - URI.toLower(string2.charAt(n5));
                    if (n6 != 0) {
                        return n6;
                    }
                    ++n5;
                }
                return n3 - n2;
            }
            return 1;
        }
        return -1;
    }

    private static void checkPath(String string, String string2, String string3) throws URISyntaxException {
        if (string2 != null && string3 != null && string3.length() > 0 && string3.charAt(0) != '/') {
            throw new URISyntaxException(string, "Relative path in absolute URI");
        }
    }

    private void appendAuthority(StringBuffer stringBuffer, String string, String string2, String string3, int n2) {
        if (string3 != null) {
            boolean bl2;
            stringBuffer.append("//");
            if (string2 != null) {
                stringBuffer.append(URI.quote(string2, L_USERINFO, H_USERINFO));
                stringBuffer.append('@');
            }
            boolean bl3 = bl2 = string3.indexOf(58) >= 0 && !string3.startsWith("[") && !string3.endsWith("]");
            if (bl2) {
                stringBuffer.append('[');
            }
            stringBuffer.append(string3);
            if (bl2) {
                stringBuffer.append(']');
            }
            if (n2 != -1) {
                stringBuffer.append(':');
                stringBuffer.append(n2);
            }
        } else if (string != null) {
            stringBuffer.append("//");
            stringBuffer.append(URI.quote(string, L_REG_NAME | L_SERVER, H_REG_NAME | H_SERVER));
        }
    }

    private void appendSchemeSpecificPart(StringBuffer stringBuffer, String string, String string2, String string3, String string4, int n2, String string5, String string6) {
        if (string != null) {
            stringBuffer.append(URI.quote(string, L_URIC, H_URIC));
        } else {
            this.appendAuthority(stringBuffer, string2, string3, string4, n2);
            if (string5 != null) {
                stringBuffer.append(URI.quote(string5, L_PATH, H_PATH));
            }
            if (string6 != null) {
                stringBuffer.append('?');
                stringBuffer.append(URI.quote(string6, L_URIC, H_URIC));
            }
        }
    }

    private void appendFragment(StringBuffer stringBuffer, String string) {
        if (string != null) {
            stringBuffer.append('#');
            stringBuffer.append(URI.quote(string, L_URIC, H_URIC));
        }
    }

    private String toString(String string, String string2, String string3, String string4, String string5, int n2, String string6, String string7, String string8) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(':');
        }
        this.appendSchemeSpecificPart(stringBuffer, string2, string3, string4, string5, n2, string6, string7);
        this.appendFragment(stringBuffer, string8);
        return stringBuffer.toString();
    }

    private void defineSchemeSpecificPart() {
        if (this.schemeSpecificPart != null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.appendSchemeSpecificPart(stringBuffer, null, this.authority, this.userInfo, this.host, this.port, this.path, this.query);
        if (stringBuffer.length() == 0) {
            return;
        }
        this.schemeSpecificPart = stringBuffer.toString();
    }

    private void defineString() {
        if (this.string != null) {
            return;
        }
        this.string = this.toString(this.scheme, this.isOpaque() ? this.schemeSpecificPart : null, this.authority, this.userInfo, this.host, this.port, this.path, this.query, this.fragment);
    }

    private static String resolvePath(String string, String string2, boolean bl2) {
        CharSequence charSequence;
        int n2 = string.lastIndexOf(47);
        int n3 = string2.length();
        String string3 = "";
        if (n3 == 0) {
            if (n2 >= 0) {
                string3 = string.substring(0, n2 + 1);
            }
        } else {
            charSequence = new StringBuffer(string.length() + n3);
            if (n2 >= 0) {
                ((StringBuffer)charSequence).append(string.substring(0, n2 + 1));
            }
            ((StringBuffer)charSequence).append(string2);
            string3 = ((StringBuffer)charSequence).toString();
        }
        charSequence = URI.normalize(string3);
        return charSequence;
    }

    private static URI resolve(URI uRI, URI uRI2) {
        if (uRI.isOpaque() || uRI2.isOpaque()) {
            return uRI2;
        }
        if (uRI2.scheme == null && uRI2.authority == null && uRI2.path.equals("") && uRI2.fragment != null && uRI2.query == null) {
            if (uRI.fragment != null && uRI2.fragment.equals(uRI.fragment)) {
                return uRI;
            }
            URI uRI3 = new URI();
            uRI3.scheme = uRI.scheme;
            uRI3.authority = uRI.authority;
            uRI3.userInfo = uRI.userInfo;
            uRI3.host = uRI.host;
            uRI3.port = uRI.port;
            uRI3.path = uRI.path;
            uRI3.fragment = uRI2.fragment;
            uRI3.query = uRI.query;
            return uRI3;
        }
        if (uRI2.scheme != null) {
            return uRI2;
        }
        URI uRI4 = new URI();
        uRI4.scheme = uRI.scheme;
        uRI4.query = uRI2.query;
        uRI4.fragment = uRI2.fragment;
        if (uRI2.authority == null) {
            String string;
            uRI4.authority = uRI.authority;
            uRI4.host = uRI.host;
            uRI4.userInfo = uRI.userInfo;
            uRI4.port = uRI.port;
            String string2 = string = uRI2.path == null ? "" : uRI2.path;
            uRI4.path = string.length() > 0 && string.charAt(0) == '/' ? uRI2.path : URI.resolvePath(uRI.path, string, uRI.isAbsolute());
        } else {
            uRI4.authority = uRI2.authority;
            uRI4.host = uRI2.host;
            uRI4.userInfo = uRI2.userInfo;
            uRI4.host = uRI2.host;
            uRI4.port = uRI2.port;
            uRI4.path = uRI2.path;
        }
        return uRI4;
    }

    private static URI normalize(URI uRI) {
        if (uRI.isOpaque() || uRI.path == null || uRI.path.length() == 0) {
            return uRI;
        }
        String string = URI.normalize(uRI.path);
        if (string == uRI.path) {
            return uRI;
        }
        URI uRI2 = new URI();
        uRI2.scheme = uRI.scheme;
        uRI2.fragment = uRI.fragment;
        uRI2.authority = uRI.authority;
        uRI2.userInfo = uRI.userInfo;
        uRI2.host = uRI.host;
        uRI2.port = uRI.port;
        uRI2.path = string;
        uRI2.query = uRI.query;
        return uRI2;
    }

    private static URI relativize(URI uRI, URI uRI2) {
        String string;
        if (uRI.isOpaque() || uRI2.isOpaque()) {
            return uRI2;
        }
        if (!URI.equalIgnoringCase(uRI.scheme, uRI2.scheme) || !URI.equal(uRI.authority, uRI2.authority)) {
            return uRI2;
        }
        String string2 = URI.normalize(uRI.path);
        if (!string2.equals(string = URI.normalize(uRI2.path))) {
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            if (!string.startsWith(string2)) {
                return uRI2;
            }
        }
        URI uRI3 = new URI();
        uRI3.path = string.substring(string2.length());
        uRI3.query = uRI2.query;
        uRI3.fragment = uRI2.fragment;
        return uRI3;
    }

    /*
     * Unable to fully structure code
     */
    private static int needsNormalization(String var0) {
        var1_1 = true;
        var2_2 = 0;
        var3_3 = var0.length() - 1;
        var4_4 = 0;
        while (var4_4 <= var3_3) {
            if (var0.charAt(var4_4) != '/') break;
            ++var4_4;
        }
        if (var4_4 > 1) {
            var1_1 = false;
        }
        block1: while (var4_4 <= var3_3) {
            if (var0.charAt(var4_4) == '.' && (var4_4 == var3_3 || var0.charAt(var4_4 + 1) == '/' || var0.charAt(var4_4 + 1) == '.' && (var4_4 + 1 == var3_3 || var0.charAt(var4_4 + 2) == '/'))) {
                var1_1 = false;
            }
            ++var2_2;
            while (var4_4 <= var3_3) {
                if (var0.charAt(var4_4++) == '/') ** GOTO lbl21
                continue;
                while (var0.charAt(var4_4) == '/') {
                    var1_1 = false;
                    ++var4_4;
lbl21:
                    // 2 sources

                    if (var4_4 <= var3_3) continue;
                    continue block1;
                }
                continue block1;
            }
        }
        return var1_1 != false ? -1 : var2_2;
    }

    private static void split(char[] cArray, int[] nArray) {
        int n2 = cArray.length - 1;
        int n3 = 0;
        int n4 = 0;
        while (n3 <= n2) {
            if (cArray[n3] != '/') break;
            cArray[n3] = '\u0000';
            ++n3;
        }
        block1: while (n3 <= n2) {
            nArray[n4++] = n3++;
            while (n3 <= n2) {
                if (cArray[n3++] != '/') continue;
                cArray[n3 - 1] = '\u0000';
                while (n3 <= n2) {
                    if (cArray[n3] != '/') continue block1;
                    cArray[n3++] = '\u0000';
                }
                continue block1;
            }
        }
        if (n4 != nArray.length) {
            throw new InternalError();
        }
    }

    private static int join(char[] cArray, int[] nArray) {
        int n2 = nArray.length;
        int n3 = cArray.length - 1;
        int n4 = 0;
        if (cArray[n4] == '\u0000') {
            cArray[n4++] = 47;
        }
        int n5 = 0;
        while (n5 < n2) {
            int n6 = nArray[n5];
            if (n6 != -1) {
                if (n4 == n6) {
                    while (n4 <= n3 && cArray[n4] != '\u0000') {
                        ++n4;
                    }
                    if (n4 <= n3) {
                        cArray[n4++] = 47;
                    }
                } else if (n4 < n6) {
                    while (n6 <= n3 && cArray[n6] != '\u0000') {
                        cArray[n4++] = cArray[n6++];
                    }
                    if (n6 <= n3) {
                        cArray[n4++] = 47;
                    }
                } else {
                    throw new InternalError();
                }
            }
            ++n5;
        }
        return n4;
    }

    private static void removeDots(char[] cArray, int[] nArray) {
        int n2 = nArray.length;
        int n3 = cArray.length - 1;
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            int n6 = 0;
            do {
                if (cArray[n5 = nArray[n4]] != '.') continue;
                if (n5 == n3) {
                    n6 = 1;
                    break;
                }
                if (cArray[n5 + 1] == '\u0000') {
                    n6 = 1;
                    break;
                }
                if (cArray[n5 + 1] != '.' || n5 + 1 != n3 && cArray[n5 + 2] != '\u0000') continue;
                n6 = 2;
                break;
            } while (++n4 < n2);
            if (n4 > n2 || n6 == 0) break;
            if (n6 == 1) {
                nArray[n4] = -1;
            } else {
                int n7;
                n5 = n4 - 1;
                while (n5 >= 0) {
                    if (nArray[n5] != -1) break;
                    --n5;
                }
                if (n5 >= 0 && (cArray[n7 = nArray[n5]] != '.' || cArray[n7 + 1] != '.' || cArray[n7 + 2] != '\u0000')) {
                    nArray[n4] = -1;
                    nArray[n5] = -1;
                }
            }
            ++n4;
        }
    }

    private static void maybeAddLeadingDot(char[] cArray, int[] nArray) {
        if (cArray[0] == '\u0000') {
            return;
        }
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (nArray[n3] >= 0) break;
            ++n3;
        }
        if (n3 >= n2 || n3 == 0) {
            return;
        }
        int n4 = nArray[n3];
        while (cArray[n4] != ':' && cArray[n4] != '\u0000') {
            ++n4;
        }
        if (cArray[n4] == '\u0000') {
            return;
        }
        cArray[0] = 46;
        cArray[1] = '\u0000';
        nArray[0] = 0;
    }

    private static String normalize(String string) {
        int n2 = URI.needsNormalization(string);
        if (n2 < 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int[] nArray = new int[n2];
        URI.split(cArray, nArray);
        URI.removeDots(cArray, nArray);
        URI.maybeAddLeadingDot(cArray, nArray);
        return new String(cArray, 0, URI.join(cArray, nArray));
    }

    private static long lowMask(String string) {
        int n2 = string.length();
        long l2 = 0L;
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (c2 < '@') {
                l2 |= 1L << c2;
            }
            ++n3;
        }
        return l2;
    }

    private static long highMask(String string) {
        int n2 = string.length();
        long l2 = 0L;
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (c2 >= '@' && c2 < '\u0080') {
                l2 |= 1L << c2 - 64;
            }
            ++n3;
        }
        return l2;
    }

    private static long lowMask(char c2, char c3) {
        long l2 = 0L;
        int n2 = Math.max(Math.min(c2, 63), 0);
        int n3 = Math.max(Math.min(c3, 63), 0);
        int n4 = n2;
        while (n4 <= n3) {
            l2 |= 1L << n4;
            ++n4;
        }
        return l2;
    }

    private static long highMask(char c2, char c3) {
        long l2 = 0L;
        int n2 = Math.max(Math.min(c2, 127), 64) - 64;
        int n3 = Math.max(Math.min(c3, 127), 64) - 64;
        int n4 = n2;
        while (n4 <= n3) {
            l2 |= 1L << n4;
            ++n4;
        }
        return l2;
    }

    private static boolean match(char c2, long l2, long l3) {
        if (c2 < '@') {
            return (1L << c2 & l2) != 0L;
        }
        if (c2 < '\u0080') {
            return (1L << c2 - 64 & l3) != 0L;
        }
        return false;
    }

    private static void appendEscape(StringBuffer stringBuffer, byte by) {
        stringBuffer.append('%');
        stringBuffer.append(hexDigits[by >> 4 & 0xF]);
        stringBuffer.append(hexDigits[by >> 0 & 0xF]);
    }

    /*
     * Unable to fully structure code
     */
    private static void appendEncoded(StringBuffer var0, char var1_1) {
        var2_2 = null;
        try {
            var2_2 = ThreadLocalCoders.encoderFor("UTF-8").encode(CharBuffer.wrap("" + var1_1));
            ** GOTO lbl14
        }
        catch (CharacterCodingException var3_3) {
            if (URI.$assertionsDisabled) ** GOTO lbl14
            throw new AssertionError();
        }
lbl-1000:
        // 1 sources

        {
            var3_4 = var2_2.get() & 255;
            if (var3_4 >= 128) {
                URI.appendEscape(var0, (byte)var3_4);
                continue;
            }
            var0.append((char)var3_4);
lbl14:
            // 4 sources

            ** while (var2_2.hasRemaining())
        }
lbl15:
        // 1 sources

    }

    private static String quote(String string, long l2, long l3) {
        int n2 = string.length();
        StringBuffer stringBuffer = null;
        boolean bl2 = (l2 & 1L) != 0L;
        int n3 = 0;
        while (n3 < string.length()) {
            char c2 = string.charAt(n3);
            if (c2 < '\u0080') {
                if (!URI.match(c2, l2, l3)) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                        stringBuffer.append(string.substring(0, n3));
                    }
                    URI.appendEscape(stringBuffer, (byte)c2);
                } else if (stringBuffer != null) {
                    stringBuffer.append(c2);
                }
            } else if (bl2 && (Character.isSpaceChar(c2) || Character.isISOControl(c2))) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(string.substring(0, n3));
                }
                URI.appendEncoded(stringBuffer, c2);
            } else if (stringBuffer != null) {
                stringBuffer.append(c2);
            }
            ++n3;
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    private static String encode(String string) {
        ByteBuffer byteBuffer;
        block6: {
            int n2 = string.length();
            if (n2 == 0) {
                return string;
            }
            int n3 = 0;
            while (string.charAt(n3) < '\u0080') {
                if (++n3 < n2) continue;
                return string;
            }
            String string2 = Normalizer.normalize(string, Normalizer.COMPOSE, 0);
            byteBuffer = null;
            try {
                byteBuffer = ThreadLocalCoders.encoderFor("UTF-8").encode(CharBuffer.wrap(string2));
            }
            catch (CharacterCodingException characterCodingException) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (byteBuffer.hasRemaining()) {
            int n4 = byteBuffer.get() & 0xFF;
            if (n4 >= 128) {
                URI.appendEscape(stringBuffer, (byte)n4);
                continue;
            }
            stringBuffer.append((char)n4);
        }
        return stringBuffer.toString();
    }

    private static int decode(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return -1;
    }

    private static byte decode(char c2, char c3) {
        return (byte)((URI.decode(c2) & 0xF) << 4 | (URI.decode(c3) & 0xF) << 0);
    }

    private static String decode(String string) {
        if (string == null) {
            return string;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        if (string.indexOf(37) < 0) {
            return string;
        }
        byte[] byArray = new byte[n2];
        StringBuffer stringBuffer = new StringBuffer(n2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        CharBuffer charBuffer = CharBuffer.allocate(n2);
        CharsetDecoder charsetDecoder = ThreadLocalCoders.decoderFor("UTF-8").onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        char c2 = string.charAt(0);
        int n3 = 0;
        while (n3 < n2) {
            if (!$assertionsDisabled && c2 != string.charAt(n3)) {
                throw new AssertionError();
            }
            if (c2 != '%') {
                stringBuffer.append(c2);
                if (++n3 >= n2) break;
                c2 = string.charAt(n3);
                continue;
            }
            byteBuffer.clear();
            int n4 = n3;
            do {
                if (!$assertionsDisabled && n2 - n3 < 2) {
                    throw new AssertionError();
                }
                byteBuffer.put(URI.decode(string.charAt(++n3), string.charAt(++n3)));
            } while (++n3 < n2 && (c2 = string.charAt(n3)) == '%');
            byteBuffer.flip();
            charBuffer.clear();
            charsetDecoder.reset();
            CoderResult coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
            if (!$assertionsDisabled && !coderResult.isUnderflow()) {
                throw new AssertionError();
            }
            coderResult = charsetDecoder.flush(charBuffer);
            if (!$assertionsDisabled && !coderResult.isUnderflow()) {
                throw new AssertionError();
            }
            stringBuffer.append(charBuffer.flip().toString());
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$java$net$URI == null ? (class$java$net$URI = URI.class$("java.net.URI")) : class$java$net$URI).desiredAssertionStatus();
        L_DIGIT = URI.lowMask('0', '9');
        H_UPALPHA = URI.highMask('A', 'Z');
        H_LOWALPHA = URI.highMask('a', 'z');
        H_ALPHA = H_LOWALPHA | H_UPALPHA;
        L_ALPHANUM = L_DIGIT | 0L;
        H_ALPHANUM = 0L | H_ALPHA;
        L_HEX = L_DIGIT;
        H_HEX = URI.highMask('A', 'F') | URI.highMask('a', 'f');
        L_MARK = URI.lowMask("-_.!~*'()");
        H_MARK = URI.highMask("-_.!~*'()");
        L_UNRESERVED = L_ALPHANUM | L_MARK;
        H_UNRESERVED = H_ALPHANUM | H_MARK;
        L_RESERVED = URI.lowMask(";/?:@&=+$,[]");
        H_RESERVED = URI.highMask(";/?:@&=+$,[]");
        L_URIC = L_RESERVED | L_UNRESERVED | 1L;
        H_URIC = H_RESERVED | H_UNRESERVED | 0L;
        L_PCHAR = L_UNRESERVED | 1L | URI.lowMask(":@&=+$,");
        H_PCHAR = H_UNRESERVED | 0L | URI.highMask(":@&=+$,");
        L_PATH = L_PCHAR | URI.lowMask(";/");
        H_PATH = H_PCHAR | URI.highMask(";/");
        L_DASH = URI.lowMask("-");
        H_DASH = URI.highMask("-");
        L_DOT = URI.lowMask(".");
        H_DOT = URI.highMask(".");
        L_USERINFO = L_UNRESERVED | 1L | URI.lowMask(";:&=+$,");
        H_USERINFO = H_UNRESERVED | 0L | URI.highMask(";:&=+$,");
        L_REG_NAME = L_UNRESERVED | 1L | URI.lowMask("$,;:@&=+");
        H_REG_NAME = H_UNRESERVED | 0L | URI.highMask("$,;:@&=+");
        L_SERVER = L_USERINFO | L_ALPHANUM | L_DASH | URI.lowMask(".:@[]");
        H_SERVER = H_USERINFO | H_ALPHANUM | H_DASH | URI.highMask(".:@[]");
        L_SCHEME = 0L | L_DIGIT | URI.lowMask("+-.");
        H_SCHEME = H_ALPHA | 0L | URI.highMask("+-.");
        L_URIC_NO_SLASH = L_UNRESERVED | 1L | URI.lowMask(";?:@&=+$,");
        H_URIC_NO_SLASH = H_UNRESERVED | 0L | URI.highMask(";?:@&=+$,");
        hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }

    private class Parser {
        private String input;
        private boolean requireServerAuthority = false;
        private int ipv6byteCount = 0;

        Parser(String string) {
            this.input = string;
            URI.this.string = string;
        }

        private void fail(String string) throws URISyntaxException {
            throw new URISyntaxException(this.input, string);
        }

        private void fail(String string, int n2) throws URISyntaxException {
            throw new URISyntaxException(this.input, string, n2);
        }

        private void failExpecting(String string, int n2) throws URISyntaxException {
            this.fail("Expected " + string, n2);
        }

        private void failExpecting(String string, String string2, int n2) throws URISyntaxException {
            this.fail("Expected " + string + " following " + string2, n2);
        }

        private String substring(int n2, int n3) {
            return this.input.substring(n2, n3);
        }

        private char charAt(int n2) {
            return this.input.charAt(n2);
        }

        private boolean at(int n2, int n3, char c2) {
            return n2 < n3 && this.charAt(n2) == c2;
        }

        private boolean at(int n2, int n3, String string) {
            int n4 = n2;
            int n5 = string.length();
            if (n5 > n3 - n4) {
                return false;
            }
            int n6 = 0;
            while (n6 < n5) {
                if (this.charAt(n4++) != string.charAt(n6++)) break;
            }
            return n6 == n5;
        }

        private int scan(int n2, int n3, char c2) {
            if (n2 < n3 && this.charAt(n2) == c2) {
                return n2 + 1;
            }
            return n2;
        }

        private int scan(int n2, int n3, String string, String string2) {
            int n4 = n2;
            while (n4 < n3) {
                char c2 = this.charAt(n4);
                if (string.indexOf(c2) >= 0) {
                    return -1;
                }
                if (string2.indexOf(c2) >= 0) break;
                ++n4;
            }
            return n4;
        }

        private int scanEscape(int n2, int n3, char c2) throws URISyntaxException {
            int n4 = n2;
            char c3 = c2;
            if (c3 == '%') {
                if (n4 + 3 <= n3 && URI.match(this.charAt(n4 + 1), L_HEX, H_HEX) && URI.match(this.charAt(n4 + 2), L_HEX, H_HEX)) {
                    return n4 + 3;
                }
                this.fail("Malformed escape pair", n4);
            } else if (c3 > '\u0080' && !Character.isSpaceChar(c3) && !Character.isISOControl(c3)) {
                return n4 + 1;
            }
            return n4;
        }

        private int scan(int n2, int n3, long l2, long l3) throws URISyntaxException {
            int n4 = n2;
            while (n4 < n3) {
                int n5;
                char c2 = this.charAt(n4);
                if (URI.match(c2, l2, l3)) {
                    ++n4;
                    continue;
                }
                if ((l2 & 1L) == 0L || (n5 = this.scanEscape(n4, n3, c2)) <= n4) break;
                n4 = n5;
            }
            return n4;
        }

        private void checkChars(int n2, int n3, long l2, long l3, String string) throws URISyntaxException {
            int n4 = this.scan(n2, n3, l2, l3);
            if (n4 < n3) {
                this.fail("Illegal character in " + string, n4);
            }
        }

        private void checkChar(int n2, long l2, long l3, String string) throws URISyntaxException {
            this.checkChars(n2, n2 + 1, l2, l3, string);
        }

        void parse(boolean bl2) throws URISyntaxException {
            int n2;
            this.requireServerAuthority = bl2;
            int n3 = this.input.length();
            int n4 = this.scan(0, n3, "/?#", ":");
            if (n4 >= 0 && this.at(n4, n3, ':')) {
                if (n4 == 0) {
                    this.failExpecting("scheme name", 0);
                }
                this.checkChar(0, 0L, H_ALPHA, "scheme name");
                this.checkChars(1, n4, L_SCHEME, H_SCHEME, "scheme name");
                URI.this.scheme = this.substring(0, n4);
                n2 = ++n4;
                if (this.at(n4, n3, '/')) {
                    n4 = this.parseHierarchical(n4, n3);
                } else {
                    int n5 = this.scan(n4, n3, "", "#");
                    if (n5 <= n4) {
                        this.failExpecting("scheme-specific part", n4);
                    }
                    this.checkChars(n4, n5, L_URIC, H_URIC, "opaque part");
                    n4 = n5;
                }
            } else {
                n2 = 0;
                n4 = this.parseHierarchical(0, n3);
            }
            URI.this.schemeSpecificPart = this.substring(n2, n4);
            if (this.at(n4, n3, '#')) {
                this.checkChars(n4 + 1, n3, L_URIC, H_URIC, "fragment");
                URI.this.fragment = this.substring(n4 + 1, n3);
                n4 = n3;
            }
            if (n4 < n3) {
                this.fail("end of URI", n4);
            }
        }

        private int parseHierarchical(int n2, int n3) throws URISyntaxException {
            int n4;
            int n5 = n2;
            if (this.at(n5, n3, '/') && this.at(n5 + 1, n3, '/')) {
                n4 = this.scan(n5 += 2, n3, "", "/?#");
                if (n4 > n5) {
                    n5 = this.parseAuthority(n5, n4);
                } else if (n4 >= n3) {
                    this.failExpecting("authority", n5);
                }
            }
            n4 = this.scan(n5, n3, "", "?#");
            this.checkChars(n5, n4, L_PATH, H_PATH, "path");
            URI.this.path = this.substring(n5, n4);
            n5 = n4;
            if (this.at(n5, n3, '?')) {
                n4 = this.scan(++n5, n3, "", "#");
                this.checkChars(n5, n4, L_URIC, H_URIC, "query");
                URI.this.query = this.substring(n5, n4);
                n5 = n4;
            }
            return n5;
        }

        private int parseAuthority(int n2, int n3) throws URISyntaxException {
            boolean bl2;
            int n4;
            int n5 = n4 = n2;
            URISyntaxException uRISyntaxException = null;
            boolean bl3 = this.scan(n4, n3, L_SERVER, H_SERVER) == n3;
            boolean bl4 = bl2 = this.scan(n4, n3, L_REG_NAME, H_REG_NAME) == n3;
            if (bl2 && !bl3) {
                URI.this.authority = this.substring(n4, n3);
                return n3;
            }
            if (bl3) {
                try {
                    n5 = this.parseServer(n4, n3);
                    if (n5 < n3) {
                        this.failExpecting("end of authority", n5);
                    }
                    URI.this.authority = this.substring(n4, n3);
                }
                catch (URISyntaxException uRISyntaxException2) {
                    URI.this.userInfo = null;
                    URI.this.host = null;
                    URI.this.port = -1;
                    if (this.requireServerAuthority) {
                        throw uRISyntaxException2;
                    }
                    uRISyntaxException = uRISyntaxException2;
                    n5 = n4;
                }
            }
            if (n5 < n3) {
                if (bl2) {
                    URI.this.authority = this.substring(n4, n3);
                } else {
                    if (uRISyntaxException != null) {
                        throw uRISyntaxException;
                    }
                    this.fail("Illegal character in authority", n5);
                }
            }
            return n3;
        }

        private int parseServer(int n2, int n3) throws URISyntaxException {
            int n4 = n2;
            int n5 = this.scan(n4, n3, "/?#", "@");
            if (n5 >= n4 && this.at(n5, n3, '@')) {
                this.checkChars(n4, n5, L_USERINFO, H_USERINFO, "user info");
                URI.this.userInfo = this.substring(n4, n5);
                n4 = n5 + 1;
            }
            if (this.at(n4, n3, '[')) {
                if ((n5 = this.scan(++n4, n3, "/?#", "]")) > n4 && this.at(n5, n3, ']')) {
                    this.parseIPv6Reference(n4, n5);
                    n4 = n5 + 1;
                } else {
                    this.failExpecting("closing bracket for IPv6 address", n5);
                }
            } else {
                n5 = this.parseIPv4Address(n4, n3);
                if (n5 <= n4) {
                    n5 = this.parseHostname(n4, n3);
                }
                n4 = n5;
            }
            if (this.at(n4, n3, ':') && (n5 = this.scan(++n4, n3, "", "/")) > n4) {
                this.checkChars(n4, n5, L_DIGIT, 0L, "port number");
                try {
                    URI.this.port = Integer.parseInt(this.substring(n4, n5));
                }
                catch (NumberFormatException numberFormatException) {
                    this.fail("Malformed port number", n4);
                }
                n4 = n5;
            }
            if (n4 < n3) {
                this.failExpecting("port number", n4);
            }
            return n4;
        }

        private int scanByte(int n2, int n3) throws URISyntaxException {
            int n4 = n2;
            int n5 = this.scan(n4, n3, L_DIGIT, 0L);
            if (n5 <= n4) {
                return n5;
            }
            if (Integer.parseInt(this.substring(n4, n5)) > 255) {
                return n4;
            }
            return n5;
        }

        private int scanIPv4Address(int n2, int n3, boolean bl2) throws URISyntaxException {
            int n4 = n2;
            int n5 = this.scan(n4, n3, L_DIGIT | L_DOT, 0L | H_DOT);
            if (n5 <= n4 || bl2 && n5 != n3) {
                return -1;
            }
            int n6 = this.scanByte(n4, n5);
            if (n6 > n4 && (n6 = this.scan(n4 = n6, n5, '.')) > n4 && (n6 = this.scanByte(n4 = n6, n5)) > n4 && (n6 = this.scan(n4 = n6, n5, '.')) > n4 && (n6 = this.scanByte(n4 = n6, n5)) > n4 && (n6 = this.scan(n4 = n6, n5, '.')) > n4 && (n6 = this.scanByte(n4 = n6, n5)) > n4) {
                n4 = n6;
                if (n6 >= n5) {
                    return n6;
                }
            }
            this.fail("Malformed IPv4 address", n6);
            return -1;
        }

        private int takeIPv4Address(int n2, int n3, String string) throws URISyntaxException {
            int n4 = this.scanIPv4Address(n2, n3, true);
            if (n4 <= n2) {
                this.failExpecting(string, n2);
            }
            return n4;
        }

        private int parseIPv4Address(int n2, int n3) throws URISyntaxException {
            int n4 = this.scanIPv4Address(n2, n3, false);
            if (n4 > n2) {
                URI.this.host = this.substring(n2, n4);
            }
            return n4;
        }

        private int parseHostname(int n2, int n3) throws URISyntaxException {
            int n4;
            int n5 = n2;
            int n6 = -1;
            while ((n4 = this.scan(n5, n3, L_ALPHANUM, H_ALPHANUM)) > n5) {
                n6 = n5;
                if (n4 > n5 && (n4 = this.scan(n5 = n4, n3, L_ALPHANUM | L_DASH, H_ALPHANUM | H_DASH)) > n5) {
                    if (this.charAt(n4 - 1) == '-') {
                        this.fail("Illegal character in hostname", n4 - 1);
                    }
                    n5 = n4;
                }
                if ((n4 = this.scan(n5, n3, '.')) > n5 && (n5 = n4) < n3) continue;
            }
            if (n5 < n3 && !this.at(n5, n3, ':')) {
                this.fail("Illegal character in hostname", n5);
            }
            if (n6 < 0) {
                this.failExpecting("hostname", n2);
            }
            if (!URI.match(this.charAt(n6), 0L, H_ALPHA)) {
                this.fail("Illegal character in hostname", n6);
            }
            URI.this.host = this.substring(n2, n5);
            return n5;
        }

        private int parseIPv6Reference(int n2, int n3) throws URISyntaxException {
            int n4 = n2;
            int n5 = this.scanHexSeq(n4, n3);
            if (n5 > n4) {
                n4 = n5;
                if (this.at(n4, n3, "::")) {
                    n4 = this.scanHexPost(n4 + 2, n3);
                } else if (this.at(n4, n3, ':')) {
                    n4 = this.takeIPv4Address(n4 + 1, n3, "IPv4 address");
                    this.ipv6byteCount += 4;
                }
            } else if (this.at(n4, n3, "::")) {
                n4 = this.scanHexPost(n4 + 2, n3);
            }
            if (n4 < n3) {
                this.fail("Malformed IPv6 address", n2);
            }
            if (this.ipv6byteCount > 16) {
                this.fail("IPv6 address too long", n2);
            }
            URI.this.host = this.substring(n2 - 1, n4 + 1);
            return n4;
        }

        private int scanHexPost(int n2, int n3) throws URISyntaxException {
            int n4 = n2;
            if (n4 == n3) {
                return n4;
            }
            int n5 = this.scanHexSeq(n4, n3);
            if (n5 > n4) {
                n4 = n5;
                if (this.at(n4, n3, ':')) {
                    ++n4;
                    n4 = this.takeIPv4Address(n4, n3, "hex digits or IPv4 address");
                    this.ipv6byteCount += 4;
                }
            } else {
                n4 = this.takeIPv4Address(n4, n3, "hex digits or IPv4 address");
                this.ipv6byteCount += 4;
            }
            return n4;
        }

        private int scanHexSeq(int n2, int n3) throws URISyntaxException {
            int n4 = n2;
            int n5 = this.scan(n4, n3, L_HEX, H_HEX);
            if (n5 <= n4) {
                return -1;
            }
            if (this.at(n5, n3, '.')) {
                return -1;
            }
            this.ipv6byteCount += 2;
            n4 = n5;
            while (n4 < n3) {
                if (!this.at(n4, n3, ':') || this.at(n4 + 1, n3, ':')) break;
                if ((n5 = this.scan(++n4, n3, L_HEX, H_HEX)) <= n4) {
                    this.failExpecting("digits for an IPv6 address", n4);
                }
                if (this.at(n5, n3, '.')) {
                    --n4;
                    break;
                }
                if (n5 > n4 + 4) {
                    this.fail("IPv6 hexadecimal digit sequence too long", n4);
                }
                this.ipv6byteCount += 2;
                n4 = n5;
            }
            return n4;
        }
    }
}

