/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.RectIterator;
import java.awt.geom.RectangularShape;

public abstract class Rectangle2D
extends RectangularShape {
    public static final int OUT_LEFT = 1;
    public static final int OUT_TOP = 2;
    public static final int OUT_RIGHT = 4;
    public static final int OUT_BOTTOM = 8;

    protected Rectangle2D() {
    }

    public abstract void setRect(double var1, double var3, double var5, double var7);

    public void setRect(Rectangle2D rectangle2D) {
        this.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    /*
     * Unable to fully structure code
     */
    public boolean intersectsLine(double var1_1, double var3_2, double var5_3, double var7_4) {
        var10_5 = this.outcode(var5_3, var7_4);
        if (var10_5 != 0) ** GOTO lbl18
        return true;
lbl-1000:
        // 1 sources

        {
            if ((var9_6 & var10_5) != 0) {
                return false;
            }
            if ((var9_6 & 5) != 0) {
                var11_7 = this.getX();
                if ((var9_6 & 4) != 0) {
                    var11_7 += this.getWidth();
                }
                var3_2 += (var11_7 - var1_1) * (var7_4 - var3_2) / (var5_3 - var1_1);
                var1_1 = var11_7;
                continue;
            }
            var11_7 = this.getY();
            if ((var9_6 & 8) != 0) {
                var11_7 += this.getHeight();
            }
            var1_1 += (var11_7 - var3_2) * (var5_3 - var1_1) / (var7_4 - var3_2);
            var3_2 = var11_7;
lbl18:
            // 3 sources

            ** while ((var9_6 = this.outcode((double)var1_1, (double)var3_2)) != 0)
        }
lbl19:
        // 1 sources

        return true;
    }

    public boolean intersectsLine(Line2D line2D) {
        return this.intersectsLine(line2D.getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2());
    }

    public abstract int outcode(double var1, double var3);

    public int outcode(Point2D point2D) {
        return this.outcode(point2D.getX(), point2D.getY());
    }

    public void setFrame(double d2, double d3, double d4, double d5) {
        this.setRect(d2, d3, d4, d5);
    }

    public Rectangle2D getBounds2D() {
        return (Rectangle2D)this.clone();
    }

    public boolean contains(double d2, double d3) {
        double d4 = this.getX();
        double d5 = this.getY();
        return d2 >= d4 && d3 >= d5 && d2 < d4 + this.getWidth() && d3 < d5 + this.getHeight();
    }

    public boolean intersects(double d2, double d3, double d4, double d5) {
        if (this.isEmpty() || d4 <= 0.0 || d5 <= 0.0) {
            return false;
        }
        double d6 = this.getX();
        double d7 = this.getY();
        return d2 + d4 > d6 && d3 + d5 > d7 && d2 < d6 + this.getWidth() && d3 < d7 + this.getHeight();
    }

    public boolean contains(double d2, double d3, double d4, double d5) {
        if (this.isEmpty() || d4 <= 0.0 || d5 <= 0.0) {
            return false;
        }
        double d6 = this.getX();
        double d7 = this.getY();
        return d2 >= d6 && d3 >= d7 && d2 + d4 <= d6 + this.getWidth() && d3 + d5 <= d7 + this.getHeight();
    }

    public abstract Rectangle2D createIntersection(Rectangle2D var1);

    public static void intersect(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3) {
        double d2 = Math.max(rectangle2D.getMinX(), rectangle2D2.getMinX());
        double d3 = Math.max(rectangle2D.getMinY(), rectangle2D2.getMinY());
        double d4 = Math.min(rectangle2D.getMaxX(), rectangle2D2.getMaxX());
        double d5 = Math.min(rectangle2D.getMaxY(), rectangle2D2.getMaxY());
        rectangle2D3.setFrame(d2, d3, d4 - d2, d5 - d3);
    }

    public abstract Rectangle2D createUnion(Rectangle2D var1);

    public static void union(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3) {
        double d2 = Math.min(rectangle2D.getMinX(), rectangle2D2.getMinX());
        double d3 = Math.min(rectangle2D.getMinY(), rectangle2D2.getMinY());
        double d4 = Math.max(rectangle2D.getMaxX(), rectangle2D2.getMaxX());
        double d5 = Math.max(rectangle2D.getMaxY(), rectangle2D2.getMaxY());
        rectangle2D3.setFrameFromDiagonal(d2, d3, d4, d5);
    }

    public void add(double d2, double d3) {
        double d4 = Math.min(this.getMinX(), d2);
        double d5 = Math.max(this.getMaxX(), d2);
        double d6 = Math.min(this.getMinY(), d3);
        double d7 = Math.max(this.getMaxY(), d3);
        this.setRect(d4, d6, d5 - d4, d7 - d6);
    }

    public void add(Point2D point2D) {
        this.add(point2D.getX(), point2D.getY());
    }

    public void add(Rectangle2D rectangle2D) {
        double d2 = Math.min(this.getMinX(), rectangle2D.getMinX());
        double d3 = Math.max(this.getMaxX(), rectangle2D.getMaxX());
        double d4 = Math.min(this.getMinY(), rectangle2D.getMinY());
        double d5 = Math.max(this.getMaxY(), rectangle2D.getMaxY());
        this.setRect(d2, d4, d3 - d2, d5 - d4);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new RectIterator(this, affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d2) {
        return new RectIterator(this, affineTransform);
    }

    public int hashCode() {
        long l2 = java.lang.Double.doubleToLongBits(this.getX());
        l2 += java.lang.Double.doubleToLongBits(this.getY()) * 37L;
        l2 += java.lang.Double.doubleToLongBits(this.getWidth()) * 43L;
        return (int)(l2 += java.lang.Double.doubleToLongBits(this.getHeight()) * 47L) ^ (int)(l2 >> 32);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)object;
            return this.getX() == rectangle2D.getX() && this.getY() == rectangle2D.getY() && this.getWidth() == rectangle2D.getWidth() && this.getHeight() == rectangle2D.getHeight();
        }
        return false;
    }

    public static class Double
    extends Rectangle2D {
        public double x;
        public double y;
        public double width;
        public double height;

        public Double() {
        }

        public Double(double d2, double d3, double d4, double d5) {
            this.setRect(d2, d3, d4, d5);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        public void setRect(double d2, double d3, double d4, double d5) {
            this.x = d2;
            this.y = d3;
            this.width = d4;
            this.height = d5;
        }

        public void setRect(Rectangle2D rectangle2D) {
            this.x = rectangle2D.getX();
            this.y = rectangle2D.getY();
            this.width = rectangle2D.getWidth();
            this.height = rectangle2D.getHeight();
        }

        public int outcode(double d2, double d3) {
            int n2 = 0;
            if (this.width <= 0.0) {
                n2 |= 5;
            } else if (d2 < this.x) {
                n2 |= 1;
            } else if (d2 > this.x + this.width) {
                n2 |= 4;
            }
            if (this.height <= 0.0) {
                n2 |= 0xA;
            } else if (d3 < this.y) {
                n2 |= 2;
            } else if (d3 > this.y + this.height) {
                n2 |= 8;
            }
            return n2;
        }

        public Rectangle2D getBounds2D() {
            return new Double(this.x, this.y, this.width, this.height);
        }

        public Rectangle2D createIntersection(Rectangle2D rectangle2D) {
            Double double_ = new Double();
            Rectangle2D.intersect(this, rectangle2D, double_);
            return double_;
        }

        public Rectangle2D createUnion(Rectangle2D rectangle2D) {
            Double double_ = new Double();
            Rectangle2D.union(this, rectangle2D, double_);
            return double_;
        }

        public String toString() {
            return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + "]";
        }
    }

    public static class Float
    extends Rectangle2D {
        public float x;
        public float y;
        public float width;
        public float height;

        public Float() {
        }

        public Float(float f2, float f3, float f4, float f5) {
            this.setRect(f2, f3, f4, f5);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0f || this.height <= 0.0f;
        }

        public void setRect(float f2, float f3, float f4, float f5) {
            this.x = f2;
            this.y = f3;
            this.width = f4;
            this.height = f5;
        }

        public void setRect(double d2, double d3, double d4, double d5) {
            this.x = (float)d2;
            this.y = (float)d3;
            this.width = (float)d4;
            this.height = (float)d5;
        }

        public void setRect(Rectangle2D rectangle2D) {
            this.x = (float)rectangle2D.getX();
            this.y = (float)rectangle2D.getY();
            this.width = (float)rectangle2D.getWidth();
            this.height = (float)rectangle2D.getHeight();
        }

        public int outcode(double d2, double d3) {
            int n2 = 0;
            if (this.width <= 0.0f) {
                n2 |= 5;
            } else if (d2 < (double)this.x) {
                n2 |= 1;
            } else if (d2 > (double)this.x + (double)this.width) {
                n2 |= 4;
            }
            if (this.height <= 0.0f) {
                n2 |= 0xA;
            } else if (d3 < (double)this.y) {
                n2 |= 2;
            } else if (d3 > (double)this.y + (double)this.height) {
                n2 |= 8;
            }
            return n2;
        }

        public Rectangle2D getBounds2D() {
            return new Float(this.x, this.y, this.width, this.height);
        }

        public Rectangle2D createIntersection(Rectangle2D rectangle2D) {
            Rectangle2D rectangle2D2 = rectangle2D instanceof Float ? new Float() : new Double();
            Rectangle2D.intersect(this, rectangle2D, rectangle2D2);
            return rectangle2D2;
        }

        public Rectangle2D createUnion(Rectangle2D rectangle2D) {
            Rectangle2D rectangle2D2 = rectangle2D instanceof Float ? new Float() : new Double();
            Rectangle2D.union(this, rectangle2D, rectangle2D2);
            return rectangle2D2;
        }

        public String toString() {
            return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + "]";
        }
    }
}

