/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth.module;

import com.sun.security.auth.NTDomainPrincipal;
import com.sun.security.auth.NTNumericCredential;
import com.sun.security.auth.NTSidDomainPrincipal;
import com.sun.security.auth.NTSidGroupPrincipal;
import com.sun.security.auth.NTSidPrimaryGroupPrincipal;
import com.sun.security.auth.NTSidUserPrincipal;
import com.sun.security.auth.NTUserPrincipal;
import com.sun.security.auth.module.NTSystem;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class NTLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private NTUserPrincipal ntUserPrincipal;
    private NTDomainPrincipal ntDomainPrincipal;
    private NTSidDomainPrincipal ntSidDomainPrincipal;
    private NTSidUserPrincipal ntSidUserPrincipal;
    private NTSidGroupPrincipal[] ntSidGroupPrincipals;
    private NTSidPrimaryGroupPrincipal ntSidPrimaryGroupPrincipal;
    private NTNumericCredential ntNumericCredential;
    private NTSystem ntSystem;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.debug = "true".equalsIgnoreCase((String)map2.get("debug"));
    }

    public boolean login() throws LoginException {
        this.ntSystem = null;
        this.succeeded = false;
        this.ntSystem = new NTSystem();
        if (this.ntSystem == null) {
            if (this.debug) {
                System.out.println("\t\t[NTLoginModule] Failed in NT login");
            }
            throw new FailedLoginException("Failed in attempt to import the underlying NT system identity information");
        }
        this.ntUserPrincipal = new NTUserPrincipal(this.ntSystem.getName());
        this.ntDomainPrincipal = new NTDomainPrincipal(this.ntSystem.getDomain());
        String[] stringArray = this.ntSystem.getDomainSID();
        if (!stringArray.equals(new String(""))) {
            this.ntSidDomainPrincipal = new NTSidDomainPrincipal((String)stringArray);
            stringArray = null;
        }
        this.ntSidUserPrincipal = new NTSidUserPrincipal(this.ntSystem.getUserSID());
        stringArray = this.ntSystem.getGroupIDs();
        this.ntSidGroupPrincipals = new NTSidGroupPrincipal[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.ntSidGroupPrincipals[n2] = new NTSidGroupPrincipal(stringArray[n2]);
            ++n2;
        }
        this.ntSidPrimaryGroupPrincipal = new NTSidPrimaryGroupPrincipal(this.ntSystem.getPrimaryGroupID());
        this.ntNumericCredential = new NTNumericCredential(this.ntSystem.getImpersonationToken());
        if (this.debug) {
            System.out.println("\t\t[NTLoginModule] succeeded importing info: ");
            System.out.println("\t\t\tuserID = " + this.ntUserPrincipal.getName());
            System.out.println("\t\t\tdomain = " + this.ntDomainPrincipal.getName());
            if (this.ntSidDomainPrincipal == null) {
                System.out.println("\t\t\tdomainSID = null");
            } else {
                System.out.println("\t\t\tdomainSID = " + this.ntSidDomainPrincipal.getName());
            }
            System.out.println("\t\t\tuserSID = " + this.ntSidUserPrincipal.getName());
            System.out.println("\t\t\tprimary group ID = " + this.ntSidPrimaryGroupPrincipal.getName());
            if (this.ntSidGroupPrincipals != null) {
                int n3 = 0;
                while (n3 < this.ntSidGroupPrincipals.length) {
                    System.out.println("\t\t\tgroup ID = " + this.ntSidGroupPrincipals[n3].getName());
                    ++n3;
                }
            }
            System.out.println("\t\t\timpersonationToken = " + Integer.toString(this.ntNumericCredential.getToken()));
        }
        this.succeeded = true;
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            if (this.debug) {
                System.out.println("\t\t[NTLoginModule]: did not add any Principals to Subject because own authentication failed.");
            }
            return false;
        }
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is ReadOnly");
        }
        Set set = this.subject.getPrincipals();
        if (!set.contains(this.ntUserPrincipal)) {
            set.add(this.ntUserPrincipal);
        }
        if (!set.contains(this.ntDomainPrincipal)) {
            set.add(this.ntDomainPrincipal);
        }
        if (this.ntSidDomainPrincipal != null && !set.contains(this.ntSidDomainPrincipal)) {
            set.add(this.ntSidDomainPrincipal);
        }
        if (!set.contains(this.ntSidUserPrincipal)) {
            set.add(this.ntSidUserPrincipal);
        }
        if (!set.contains(this.ntSidPrimaryGroupPrincipal)) {
            set.add(this.ntSidPrimaryGroupPrincipal);
        }
        int n2 = 0;
        while (n2 < this.ntSidGroupPrincipals.length) {
            if (!set.contains(this.ntSidGroupPrincipals[n2])) {
                set.add(this.ntSidGroupPrincipals[n2]);
            }
            ++n2;
        }
        if (!this.subject.getPublicCredentials().contains(this.ntNumericCredential)) {
            this.subject.getPublicCredentials().add(this.ntNumericCredential);
        }
        if (this.debug) {
            System.out.println("\t\t[NTLoginModule] added NTPrincipal to Subject");
        }
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (this.debug) {
            System.out.println("\t\t[NTLoginModule]: aborted authentication attempt");
        }
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.ntUserPrincipal = null;
            this.ntDomainPrincipal = null;
            this.ntSidUserPrincipal = null;
            this.ntSidDomainPrincipal = null;
            this.ntSidGroupPrincipals = null;
            this.ntSidPrimaryGroupPrincipal = null;
            this.ntNumericCredential = null;
            this.ntSystem = null;
            this.succeeded = false;
        } else {
            this.logout();
        }
        return this.succeeded;
    }

    public boolean logout() throws LoginException {
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is ReadOnly");
        }
        Set set = this.subject.getPrincipals();
        if (set.contains(this.ntUserPrincipal)) {
            set.remove(this.ntUserPrincipal);
        }
        if (set.contains(this.ntDomainPrincipal)) {
            set.remove(this.ntDomainPrincipal);
        }
        if (set.contains(this.ntSidDomainPrincipal)) {
            set.remove(this.ntSidDomainPrincipal);
        }
        if (set.contains(this.ntSidUserPrincipal)) {
            set.remove(this.ntSidUserPrincipal);
        }
        int n2 = 0;
        while (n2 < this.ntSidGroupPrincipals.length) {
            if (set.contains(this.ntSidGroupPrincipals[n2])) {
                set.remove(this.ntSidGroupPrincipals[n2]);
            }
            ++n2;
        }
        if (set.contains(this.ntSidPrimaryGroupPrincipal)) {
            set.remove(this.ntSidPrimaryGroupPrincipal);
        }
        if (set.contains(this.ntNumericCredential)) {
            set.remove(this.ntNumericCredential);
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        this.ntSystem.logoff();
        this.ntUserPrincipal = null;
        this.ntDomainPrincipal = null;
        this.ntSidUserPrincipal = null;
        this.ntSidDomainPrincipal = null;
        this.ntSidGroupPrincipals = null;
        this.ntSidPrimaryGroupPrincipal = null;
        this.ntNumericCredential = null;
        this.ntSystem = null;
        if (this.debug) {
            System.out.println("\t\t[NTLoginModule] completed logout processing");
        }
        return true;
    }
}

