/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.usability;

import java.security.AccessController;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.StringTokenizer;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.usability.DialogFactory;
import sun.plugin.usability.EventMulticaster;
import sun.plugin.usability.PluginLogger;
import sun.plugin.usability.TraceListener;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;

public class Trace {
    private static boolean bBasicTraceOn = false;
    private static boolean bExtTraceOn = false;
    private static boolean bSecurityTraceOn = false;
    private static boolean bNetTraceOn = false;
    private static boolean bLiveConnectTraceOn = false;
    private static boolean bAutomationOn = false;
    private static HashMap threadGroups;

    public static void reset() {
        if (AccessController.doPrivileged(new GetBooleanAction("javaplugin.trace")).booleanValue()) {
            String string = AccessController.doPrivileged(new GetPropertyAction("javaplugin.trace.option"));
            if (string == null) {
                bBasicTraceOn = true;
                bNetTraceOn = true;
                bSecurityTraceOn = true;
                bExtTraceOn = true;
                bLiveConnectTraceOn = true;
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2 == null || string2.equalsIgnoreCase("all")) {
                        bBasicTraceOn = true;
                        bNetTraceOn = true;
                        bSecurityTraceOn = true;
                        bExtTraceOn = true;
                        bLiveConnectTraceOn = true;
                        break;
                    }
                    if (string2.equalsIgnoreCase("basic")) {
                        bBasicTraceOn = true;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("net")) {
                        bNetTraceOn = true;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("security")) {
                        bSecurityTraceOn = true;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("ext")) {
                        bExtTraceOn = true;
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("liveconnect")) continue;
                    bLiveConnectTraceOn = true;
                }
            }
        }
    }

    public static boolean isEnabled() {
        return bBasicTraceOn || bNetTraceOn || bSecurityTraceOn || bExtTraceOn || bLiveConnectTraceOn;
    }

    public static void setBasicTrace(boolean bl) {
        bBasicTraceOn = bl;
    }

    public static void setNetTrace(boolean bl) {
        bNetTraceOn = bl;
    }

    public static void setSecurityTrace(boolean bl) {
        bSecurityTraceOn = bl;
    }

    public static void setExtTrace(boolean bl) {
        bExtTraceOn = bl;
    }

    public static void setLiveConnectTrace(boolean bl) {
        bLiveConnectTraceOn = bl;
    }

    public static boolean isAutomationEnabled() {
        return bAutomationOn;
    }

    public static void println(String string) {
        Trace.println(string, null);
    }

    public static void println(String string, int n) {
        Trace.println(string, null, n);
    }

    public static void println(String string, TraceListener traceListener) {
        Trace.println(string, traceListener, 6);
    }

    public static void println(String string, TraceListener traceListener, int n) {
        if (bBasicTraceOn && (n & 2) == 2) {
            System.err.println(string);
            System.err.flush();
            PluginLogger.log(string);
        }
        Trace.firePrintlnEvent(string, traceListener, n);
    }

    public static void messagePrintln(String string, Object[] objectArray, TraceListener traceListener, int n) {
        if (bBasicTraceOn || (n & 1) == 1 || (n & 4) == 4) {
            MessageFormat messageFormat = new MessageFormat(ResourceHandler.getMessage(string));
            Trace.println(messageFormat.format(objectArray), traceListener, n);
        }
    }

    public static void printException(Throwable throwable) {
        throwable.printStackTrace();
        PluginLogger.logException(throwable);
        if (!Trace.isAutomationEnabled()) {
            Object[] objectArray = new Object[]{ResourceHandler.getMessage("usability.general_error"), throwable};
            DialogFactory.showExceptionDialog(objectArray, null);
        }
    }

    public static void printException(Throwable throwable, String string, String string2) {
        throwable.printStackTrace();
        PluginLogger.logException(string, throwable);
        if (!Trace.isAutomationEnabled()) {
            Object[] objectArray = new Object[]{string, throwable};
            DialogFactory.showExceptionDialog(objectArray, string2);
        }
    }

    public static void netPrintln(String string) {
        Trace.netPrintln(string, 2);
    }

    public static void netPrintln(String string, int n) {
        if (bNetTraceOn && (n & 2) == 2) {
            System.err.println(string);
            System.err.flush();
            PluginLogger.log(string);
        }
        Trace.firePrintlnEvent(string, null, n);
    }

    public static void messageNetPrintln(String string, Object[] objectArray) {
        if (bNetTraceOn) {
            MessageFormat messageFormat = new MessageFormat(ResourceHandler.getMessage(string));
            Trace.netPrintln(messageFormat.format(objectArray));
        }
    }

    public static void netPrintException(Throwable throwable) {
        throwable.printStackTrace();
        PluginLogger.logException(throwable);
        if (!Trace.isAutomationEnabled()) {
            Object[] objectArray = new Object[]{ResourceHandler.getMessage("usability.net_error"), throwable};
        }
    }

    public static void netPrintException(Throwable throwable, String string, String string2) {
        throwable.printStackTrace();
        PluginLogger.logException(string, throwable);
        Object[] objectArray = new Object[]{string, throwable};
    }

    public static void securityPrintln(String string) {
        Trace.securityPrintln(string, 2);
    }

    public static void securityPrintln(String string, int n) {
        if (bSecurityTraceOn && (n & 2) == 2) {
            System.err.println(string);
            System.err.flush();
            PluginLogger.log(string);
        }
        Trace.firePrintlnEvent(string, null, n);
    }

    public static void securityPrintException(Throwable throwable) {
        throwable.printStackTrace();
        PluginLogger.logException(throwable);
        if (!Trace.isAutomationEnabled()) {
            Object[] objectArray = new Object[]{ResourceHandler.getMessage("usability.security_error"), throwable};
            DialogFactory.showExceptionDialog(objectArray, null);
        }
    }

    public static void securityPrintException(Throwable throwable, String string, String string2) {
        throwable.printStackTrace();
        PluginLogger.logException(string, throwable);
        if (!Trace.isAutomationEnabled()) {
            Object[] objectArray = new Object[]{string, throwable};
            DialogFactory.showExceptionDialog(objectArray, string2);
        }
    }

    public static void extPrintln(String string) {
        Trace.extPrintln(string, 2);
    }

    public static void extPrintln(String string, int n) {
        if (bExtTraceOn && (n & 2) == 2) {
            System.err.println(string);
            System.err.flush();
            PluginLogger.log(string);
        }
        Trace.firePrintlnEvent(string, null, n);
    }

    public static void extPrintException(Throwable throwable) {
        throwable.printStackTrace();
        PluginLogger.logException(throwable);
        if (!Trace.isAutomationEnabled()) {
            Object[] objectArray = new Object[]{ResourceHandler.getMessage("usability.ext_error"), throwable};
            DialogFactory.showExceptionDialog(objectArray, null);
        }
    }

    public static void extPrintException(Throwable throwable, String string, String string2) {
        throwable.printStackTrace();
        PluginLogger.logException(string, throwable);
        if (!Trace.isAutomationEnabled()) {
            Object[] objectArray = new Object[]{string, throwable};
            DialogFactory.showExceptionDialog(objectArray, string2);
        }
    }

    public static void liveConnectPrintln(String string) {
        Trace.liveConnectPrintln(string, 2);
    }

    public static void liveConnectPrintln(String string, int n) {
        if (bLiveConnectTraceOn && (n & 2) == 2) {
            System.err.println(string);
            System.err.flush();
            PluginLogger.log(string);
        }
        Trace.firePrintlnEvent(string, null, n);
    }

    public static void messageLiveConnectPrintln(String string, Object[] objectArray, int n) {
        if (bLiveConnectTraceOn || (n & 1) == 1 || (n & 4) == 4) {
            MessageFormat messageFormat = new MessageFormat(ResourceHandler.getMessage(string));
            Trace.liveConnectPrintln(messageFormat.format(objectArray), n);
        }
    }

    public static void liveConnectPrintException(Throwable throwable) {
        throwable.printStackTrace();
        PluginLogger.logException(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTraceListener(ThreadGroup threadGroup, TraceListener traceListener) {
        Trace.println(ResourceHandler.getMessage("trace.listener.added") + traceListener, 2);
        HashMap hashMap = threadGroups;
        synchronized (hashMap) {
            TraceListener traceListener2 = (TraceListener)threadGroups.get(new Integer(threadGroup.hashCode()));
            traceListener2 = EventMulticaster.add(traceListener2, traceListener);
            threadGroups.put(new Integer(threadGroup.hashCode()), traceListener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTraceListener(ThreadGroup threadGroup, TraceListener traceListener) {
        Trace.println(ResourceHandler.getMessage("trace.listener.removed") + traceListener, 2);
        HashMap hashMap = threadGroups;
        synchronized (hashMap) {
            TraceListener traceListener2 = (TraceListener)threadGroups.get(new Integer(threadGroup.hashCode()));
            traceListener2 = EventMulticaster.remove(traceListener2, traceListener);
            if (traceListener2 != null) {
                threadGroups.put(new Integer(threadGroup.hashCode()), traceListener2);
            } else {
                threadGroups.remove(new Integer(threadGroup.hashCode()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void firePrintlnEvent(String string, TraceListener traceListener, int n) {
        if (traceListener != null && traceListener.isSupported(n)) {
            traceListener.println(string, n);
        } else {
            Thread thread = Thread.currentThread();
            ThreadGroup threadGroup = thread.getThreadGroup();
            TraceListener traceListener2 = null;
            HashMap hashMap = threadGroups;
            synchronized (hashMap) {
                traceListener2 = (TraceListener)threadGroups.get(new Integer(threadGroup.hashCode()));
            }
            if (traceListener2 != null) {
                traceListener2.println(string, n);
            }
        }
    }

    static {
        Trace.reset();
        bAutomationOn = AccessController.doPrivileged(new GetBooleanAction("javaplugin.automation"));
        threadGroups = new HashMap();
    }
}

