/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.io.IOException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.security.CertificateStore;
import sun.plugin.security.DeniedCertificateStore;
import sun.plugin.security.PluginCertificateStore;
import sun.plugin.security.RootCACertificateStore;
import sun.plugin.security.SessionCertificateStore;
import sun.plugin.security.TrustDeciderDialog;
import sun.plugin.usability.Trace;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.NetscapeCertTypeExtension;

public class TrustDecider {
    private static CertificateStore rootStore = new RootCACertificateStore();
    private static CertificateStore permanentStore = new PluginCertificateStore();
    private static CertificateStore sessionStore = new SessionCertificateStore();
    private static CertificateStore deniedStore = new DeniedCertificateStore();
    private static final String OID_BASIC_CONSTRAINTS = "2.5.29.19";
    private static final String OID_KEY_USAGE = "2.5.29.15";
    private static final String OID_EXTENDED_KEY_USAGE = "2.5.29.37";
    private static final String OID_NETSCAPE_CERT_TYPE = "2.16.840.1.113730.1.1";
    private static final String OID_EKU_ANY_USAGE = "2.5.29.37.0";
    private static final String OID_EKU_CODE_SIGNING = "1.3.6.1.5.5.7.3.3";
    private static final String NSCT_OBJECT_SIGNING_CA = "object_signing_ca";
    private static final String NSCT_OBJECT_SIGNING = "object_signing";
    private static final String NSCT_SSL_CA = "ssl_ca";
    private static final String NSCT_S_MIME_CA = "s_mime_ca";

    public static void reset() {
        rootStore = new RootCACertificateStore();
        permanentStore = new PluginCertificateStore();
        sessionStore = new SessionCertificateStore();
        deniedStore = new DeniedCertificateStore();
    }

    public static boolean isAllPermissionGranted(CodeSource codeSource) throws CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        Certificate[] certificateArray = codeSource.getCertificates();
        String string = codeSource.getLocation().toString();
        if (certificateArray == null) {
            if (TrustDecider.isBrowserMozilla()) {
                return TrustDecider.isAllPermissionGranted(codeSource, string, null, null, 0, null, 0, "");
            }
            return false;
        }
        rootStore.load();
        permanentStore.load();
        sessionStore.load();
        deniedStore.load();
        int n = 0;
        int n2 = 0;
        while (n2 < certificateArray.length) {
            Object object;
            Object object2;
            int n3 = n;
            CertificateExpiredException certificateExpiredException = null;
            CertificateNotYetValidException certificateNotYetValidException = null;
            n3 = n;
            while (n3 < certificateArray.length) {
                block30: {
                    object2 = null;
                    object = null;
                    if (certificateArray[n3] instanceof X509Certificate) {
                        object2 = (X509Certificate)certificateArray[n3];
                    }
                    object = n3 + 1 < certificateArray.length && certificateArray[n3 + 1] instanceof X509Certificate ? (Object)((X509Certificate)certificateArray[n3 + 1]) : object2;
                    try {
                        object2.checkValidity();
                    }
                    catch (CertificateExpiredException certificateExpiredException2) {
                        if (certificateExpiredException == null) {
                            certificateExpiredException = certificateExpiredException2;
                        }
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException2) {
                        if (certificateNotYetValidException != null) break block30;
                        certificateNotYetValidException = certificateNotYetValidException2;
                    }
                }
                if (!rootStore.contains((Certificate)object2)) {
                    Set set = object2.getCriticalExtensionOIDs();
                    if (set == null) {
                        set = Collections.EMPTY_SET;
                    }
                    if (!TrustDecider.checkBasicConstraints((X509Certificate)object2, set, n3 - n)) {
                        return false;
                    }
                    if (n3 == n ? !TrustDecider.checkLeafKeyUsage((X509Certificate)object2, set) : !TrustDecider.checkSignerKeyUsage((X509Certificate)object2, set)) {
                        return false;
                    }
                    if (!set.isEmpty()) {
                        return false;
                    }
                }
                if (!TrustDecider.isIssuerOf((X509Certificate)object2, (X509Certificate)object)) break;
                try {
                    object2.verify(((Certificate)object).getPublicKey());
                }
                catch (GeneralSecurityException generalSecurityException) {
                    return false;
                }
                ++n3;
            }
            int n4 = n2 = n3 < certificateArray.length ? n3 + 1 : n3;
            if (TrustDecider.isBrowserMozilla()) {
                object2 = TrustDecider.makeChain(certificateArray, n, n2);
                if (object2 != null) {
                    Principal principal;
                    String string2;
                    object = new int[((byte[][])object2).length];
                    int n5 = 0;
                    while (n5 < ((Object)object2).length) {
                        object[n5] = (byte[])((Object)object2[n5]).length;
                        ++n5;
                    }
                    X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
                    byte[] byArray = x509Certificate.getSignature();
                    if (TrustDecider.isAllPermissionGranted(codeSource, string, object2, (int[])object, ((Object)object2).length, byArray, byArray.length, string2 = (principal = x509Certificate.getSubjectDN()).getName())) {
                        return true;
                    }
                }
            } else {
                int n6;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                if (deniedStore.contains(certificateArray[n])) {
                    return false;
                }
                if (!rootStore.verify(certificateArray[n2 - 1])) {
                    bl2 = true;
                }
                if (permanentStore.contains(certificateArray[n])) {
                    return true;
                }
                if (sessionStore.contains(certificateArray[n])) {
                    return true;
                }
                if (certificateExpiredException != null || certificateNotYetValidException != null) {
                    bl3 = true;
                }
                if ((n6 = TrustDecider.showSecurityDialog(codeSource, bl2, bl3)) == 0) {
                    Trace.securityPrintln(ResourceHandler.getMessage("trustdecider.user.grant.session"), 2);
                    sessionStore.add(certificateArray[n]);
                    sessionStore.save();
                    bl = true;
                } else if (n6 == 2) {
                    Trace.securityPrintln(ResourceHandler.getMessage("trustdecider.user.grant.forever"), 2);
                    permanentStore.add(certificateArray[n]);
                    permanentStore.save();
                    bl = true;
                } else {
                    Trace.securityPrintln(ResourceHandler.getMessage("trustdecider.user.deny"), 2);
                    deniedStore.add(certificateArray[n]);
                    deniedStore.save();
                }
                return bl;
            }
            n = n2;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkBasicConstraints(X509Certificate x509Certificate, Set set, int n) throws CertificateException, IOException {
        set.remove(OID_BASIC_CONSTRAINTS);
        set.remove(OID_NETSCAPE_CERT_TYPE);
        if (n == 0) {
            return true;
        }
        if (x509Certificate.getExtensionValue(OID_BASIC_CONSTRAINTS) == null) {
            if (x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE) == null) return false;
            if (TrustDecider.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING_CA)) return true;
            return false;
        }
        if (x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE) != null && (TrustDecider.getNetscapeCertTypeBit(x509Certificate, NSCT_SSL_CA) || TrustDecider.getNetscapeCertTypeBit(x509Certificate, NSCT_S_MIME_CA) || TrustDecider.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING_CA)) && !TrustDecider.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING_CA)) {
            return false;
        }
        int n2 = x509Certificate.getBasicConstraints();
        if (n2 < 0) {
            return false;
        }
        if (n - 1 <= n2) return true;
        return false;
    }

    private static boolean checkLeafKeyUsage(X509Certificate x509Certificate, Set set) throws CertificateException, IOException {
        List<String> list;
        set.remove(OID_KEY_USAGE);
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray != null) {
            if (blArray.length == 0) {
                return false;
            }
            boolean bl = blArray[0];
            if (!bl) {
                return false;
            }
        }
        if ((list = x509Certificate.getExtendedKeyUsage()) != null && set.contains(OID_EXTENDED_KEY_USAGE)) {
            set.remove(OID_EXTENDED_KEY_USAGE);
            if (!list.contains(OID_EKU_ANY_USAGE) && !list.contains(OID_EKU_CODE_SIGNING)) {
                return false;
            }
        }
        return x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE) == null || TrustDecider.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING);
    }

    private static boolean checkSignerKeyUsage(X509Certificate x509Certificate, Set set) throws CertificateException, IOException {
        set.remove(OID_KEY_USAGE);
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (!(blArray == null || blArray.length >= 6 && blArray[5])) {
            return false;
        }
        List<String> list = x509Certificate.getExtendedKeyUsage();
        if (list != null && set.contains(OID_EXTENDED_KEY_USAGE)) {
            set.remove(OID_EXTENDED_KEY_USAGE);
            if (!list.contains(OID_EKU_ANY_USAGE)) {
                return false;
            }
        }
        return true;
    }

    private static boolean getNetscapeCertTypeBit(X509Certificate x509Certificate, String string) throws CertificateException, IOException {
        byte[] byArray = x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE);
        if (byArray == null) {
            return false;
        }
        DerInputStream derInputStream = new DerInputStream(byArray);
        byte[] byArray2 = derInputStream.getOctetString();
        byArray2 = new DerValue(byArray2).getUnalignedBitString().toByteArray();
        NetscapeCertTypeExtension netscapeCertTypeExtension = new NetscapeCertTypeExtension(byArray2);
        Boolean bl = (Boolean)netscapeCertTypeExtension.get(string);
        return bl;
    }

    private static boolean isBrowserMozilla() {
        return false;
    }

    private static boolean isAllPermissionGranted(CodeSource codeSource, String string, byte[][] byArray, int[] nArray, int n, byte[] byArray2, int n2, String string2) {
        return false;
    }

    private static byte[][] makeChain(Certificate[] certificateArray, int n, int n2) throws CertificateEncodingException {
        if (n == n2) {
            return null;
        }
        byte[][] byArrayArray = new byte[n2 - n][];
        int n3 = n;
        while (n3 < n2) {
            byArrayArray[n3 - n] = certificateArray[n3].getEncoded();
            ++n3;
        }
        return byArrayArray;
    }

    private static boolean isIssuerOf(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        Principal principal;
        Principal principal2 = x509Certificate.getIssuerDN();
        return principal2.equals(principal = x509Certificate2.getSubjectDN());
    }

    static int showSecurityDialog(CodeSource codeSource, boolean bl, boolean bl2) {
        Integer n = (Integer)AccessController.doPrivileged(new PrivilegedBlockAction(codeSource, bl, bl2));
        int n2 = 2;
        if (n != null) {
            n2 = n;
        }
        return n2;
    }

    private static class PrivilegedBlockAction
    implements PrivilegedAction {
        Certificate[] certs;
        boolean rootCANotValid = false;
        boolean timeNotValid = false;

        PrivilegedBlockAction(CodeSource codeSource, boolean bl, boolean bl2) {
            this.certs = codeSource.getCertificates();
            this.rootCANotValid = bl;
            this.timeNotValid = bl2;
        }

        public Object run() {
            TrustDeciderDialog trustDeciderDialog = new TrustDeciderDialog(this.certs, this.rootCANotValid, this.timeNotValid);
            return new Integer(trustDeciderDialog.DoModal());
        }
    }
}

